<?php

return <<<'VALUE'
"namespace IPS\\Theme;\nclass class_nexus_front_store extends \\IPS\\Theme\\Template\n{\n\tpublic $cache_key = 'eb3f847938f9c2e3e1bf899066121da7';\n\tfunction cart( $location, $currency ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div class='ipsBox_alt'>\n\t<div class='ipsType_center ipsPad'>\n\t\t<i class='ipsType_huge fa fa-shopping-cart'><\/i>\n\t\t<h1 class='ipsType_reset ipsType_veryLarge ipsType_center'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'your_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h1>\n\t<\/div>\n\n\t<div data-controller='nexus.front.store.cartReview'>\n\t\t<div data-role=\"cart\">\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->cartContents( $location, $currency );\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/div>\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction cartContents( $location, $currency ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\n$subtotal = new \\IPS\\Math\\Number('0');\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( \\count( $_SESSION['cart'] ) ):\n$return .= <<<CONTENT\n\n\t<div class='ipsClearfix' id='elNexusCart'>\n\t\t<div class='ipsBox ipsPad_half'>\n\t\t\t\nCONTENT;\n\nforeach ( $_SESSION['cart'] as $id => $item ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $item instanceof \\IPS\\nexus\\extensions\\nexus\\Item\\Package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\ntry { $package = \\IPS\\nexus\\Package::load( $item->id ); } catch( \\OutOfRangeException $e ) { unset($_SESSION['cart'][$key]); continue; } \n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<div id='elCartItem_\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class=\"ipsClearfix\">\n\t\t\t\t\t<div class='ipsPos_left ipsPad_half'>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $item instanceof \\IPS\\nexus\\extensions\\nexus\\Item\\Package and $package->image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<img src=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsThumb ipsThumb_small'>\n\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<div class='ipsNoThumb ipsNoThumb_product ipsThumb_small'>&nbsp;<\/div>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsPos_left ipsPad_half'>\n\t\t\t\t\t\t<h2 class='ipsDataItem_title ipsType_sectionHead ipsType_break'>\nCONTENT;\n\nif ( !$package->subscription ):\n$return .= <<<CONTENT\n<span class='ipsType_light'>\nCONTENT;\n$return .= htmlspecialchars( $item->quantity, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n x<\/span> \nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n$return .= htmlspecialchars( $item->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $item->details as $k => $v ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$val = \"nexus_pfield_{$k}\"; $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( $val, ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n: <\/strong> \nCONTENT;\n\n$return .= \\IPS\\nexus\\Package\\CustomField::load( $k )->displayValue( $v );\n$return .= <<<CONTENT\n<br>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='ipsDataItem_meta ipsSpacer_top ipsSpacer_half'>\n\t\t\t\t\t\t\t<ul class='ipsList_inline ipsType_small'>\n\t\t\t\t\t\t\t\t<li><a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart&do=quantities&item[$id]=0\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'remove_from_cart_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' data-action='removeFromCart'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'remove_from_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a><\/li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( !$package->subscription ):\n$return .= <<<CONTENT\n<li><a href='#elItemRow\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_quantity_menu' data-ipsMenu data-ipsMenu-appendTo='#elCartItem_\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-ipsMenu-closeOnClick='false' id='elItemRow\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_quantity' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'change_quantity_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'change_quantity', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <i class='fa fa-caret-down'><\/i><\/a><\/li>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t<div class='ipsPad ipsHide ipsMenu ipsMenu_veryNarrow ipsType_center' id='elItemRow\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_quantity_menu'>\n\t\t\t\t\t\t\t\t<form action=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart&do=quantities\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" method=\"post\" data-role='quantityForm'>\n\t\t\t\t\t\t\t\t\t<input type='number' name=\"item[\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n]\" value='\nCONTENT;\n$return .= htmlspecialchars( $item->quantity, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t\t\t<button type='submit' class='ipsButton ipsButton_primary ipsButton_verySmall ipsButton_fullWidth ipsSpacer_top'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'update', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/button>\n\t\t\t\t\t\t\t\t<\/form>\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsPos_right ipsPad_half ipsType_right ipsPos_top'>\n\t\t\t\t\t\t<span class='cNexusPrice ipsType_large'>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->nexus_show_tax ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$location = $location ?: \\IPS\\nexus\\Customer::loggedIn()->estimatedLocation();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$itemPrice = $item->grossPrice( $location );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$linePrice = $item->grossLinePrice( $location );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$itemPrice = $item->price;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$linePrice = $item->linePrice();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $linePrice, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$subtotal = $subtotal->add( $linePrice->amount );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $item->renewalTerm ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<p class='ipsType_reset ipsType_small ipsType_light'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$sprintf = array($item->renewalTerm->toDisplay( NULL, $item->quantity )); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'and_renewal', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/p>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $item->quantity > 1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<p class='ipsType_reset ipsType_small ipsType_light'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $item->renewalTerm ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$sprintf = array($itemPrice, $item->renewalTerm); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'each_short_with_renewal', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$sprintf = array($itemPrice); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'each_short', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/p>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t<hr class='ipsHr'>\n\t\t\t<div class='cNexusCart_totals ipsType_right'>\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'cart_subtotal', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n: <span class='cNexusPrice'>\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $subtotal, $currency );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<\/div>\n\t\t<\/div>\n\t<\/div>\n\t<ul class=\"ipsToolList ipsToolList_horizontal ipsClearfix ipsSpacer_both\">\n\t\t<li class='ipsPos_left'>\n\t\t\t<a class=\"ipsButton ipsButton_medium ipsButton_link ipsButton_narrow\" href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart&do=clear\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" title=\"\" data-confirm><i class='fa fa-times'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'empty_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t\t<li class=\"ipsToolList_primaryAction\">\n\t\t\t<a class=\"ipsButton ipsButton_large ipsButton_important ipsButton_fullWidth\" href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart&do=checkout\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" title=\"\" data-action=\"checkout\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'checkout', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n &nbsp;<i class='fa fa-chevron-right ipsPos_middle'><\/i><\/a>\n\t\t<\/li>\n\t\t<li class=\"ipsToolList_primaryAction\">\n\t\t\t<a class=\"ipsButton ipsButton_large ipsButton_light ipsButton_fullWidth\" href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store\", null, \"store\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" title=\"\"><i class='fa fa-chevron-left ipsPos_middle'><\/i>&nbsp; \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'continue_shopping', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t<\/ul>\n\t<br>\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t<div class='ipsBox ipsPad ipsType_center ipsType_large ipsType_light'>\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'your_cart_empty', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t<br><br>\n\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store\", null, \"store\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'start_shopping', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' class='ipsButton ipsButton_primary ipsButton_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'start_shopping', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction cartHeader(  ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\n$location = NULL;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( isset( $_SESSION['cart'] ) and \\count( $_SESSION['cart'] ) and \\IPS\\Member::loggedIn()->canAccessModule( \\IPS\\Application\\Module::get( 'nexus', 'store' ) ) ):\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\n$subtotal = new \\IPS\\Math\\Number('0');\n$return .= <<<CONTENT\n\n\t<li class='cUserNav_icon' id='elCart_container'>\n\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' id='elCart' data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'your_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' data-ipsMenu data-ipsMenu-closeOnClick='false'>\n\t\t\t<i class='fa fa-shopping-cart'><\/i> <span class='ipsNotificationCount'>\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\nexus\\Application::cartCount(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t&nbsp;\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <i class='fa fa-caret-down'><\/i>\n\t\t<\/a>\n\t\t<div id='elCart_menu' class='ipsMenu ipsMenu_wide ipsHide'>\n\t\t\t<div class=\"ipsMenu_headerBar\"><h4 class=\"ipsType_sectionHead\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'your_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4><\/div>\n\t\t\t<div class='ipsMenu_innerContent ipsPad_half'>\n\t\t\t\t<ul class='ipsDataList' data-role='cartList' id='elCartContent'>\n\t\t\t\t\t\nCONTENT;\n\nforeach ( $_SESSION['cart'] as $id => $item ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nif ( $item instanceof \\IPS\\nexus\\extensions\\nexus\\Item\\Package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\ntry { $package = \\IPS\\nexus\\Package::load( $item->id ); } catch( \\OutOfRangeException $e ) { unset($_SESSION['cart'][$id]); continue; } \n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<li class='ipsDataItem cNexusMiniCart_row'>\n\t\t\t\t\t\t\t<div class='ipsDataItem_icon'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $item instanceof \\IPS\\nexus\\extensions\\nexus\\Item\\Package and $package->image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<img src=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsThumb ipsThumb_tiny' alt=\"\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<div class='ipsThumb_tiny ipsNoThumb ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t\t\t<span class='ipsType_medium ipsType_reset ipsType_unbold'>\nCONTENT;\n$return .= htmlspecialchars( $item->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size1 ipsType_center'>\n\t\t\t\t\t\t\t\t&times;\nCONTENT;\n$return .= htmlspecialchars( $item->quantity, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size3 cNexusPrice ipsType_normal ipsType_right'>\n\t\t\t\t\t\t\t\t<strong>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->nexus_show_tax ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$location = $location ?: \\IPS\\nexus\\Customer::loggedIn()->estimatedLocation();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$linePrice = $item->grossLinePrice( $location );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$linePrice = $item->linePrice();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $linePrice, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$subtotal = $subtotal->add( $linePrice->amount );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/strong>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $item->quantity > 1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<p class='ipsType_reset ipsType_small ipsType_light'>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$sprintf = array($item->price); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'each_short', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/p>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li class='ipsDataItem cNexusMenuCart_totalRow'>\n\t\t\t\t\t\t<div class='ipsDataItem_main ipsType_large ipsType_right'>\n\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'subtotal', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size3 cNexusPrice ipsType_large ipsType_right'>\n\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $subtotal, ( ( isset( \\IPS\\Request::i()->cookie['currency'] ) and \\in_array( \\IPS\\Request::i()->cookie['currency'], \\IPS\\nexus\\Money::currencies() ) ) ? \\IPS\\Request::i()->cookie['currency'] : \\IPS\\nexus\\Customer::loggedIn()->defaultCurrency() ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/li>\n\t\t\t\t<\/ul>\n\t\t\t<\/div>\n\t\t\t<div class='ipsMenu_footerBar ipsType_center'>\n\t\t\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' class='ipsButton ipsButton_small ipsButton_primary'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'review_and_checkout', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t<\/div>\n\t\t<\/div>\n\t<\/li>\n\t<li class='elUserNav_sep' id='elCart_sep'><\/li>\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t<li class='cUserNav_icon ipsHide' id='elCart_container'><\/li>\n\t<li class='elUserNav_sep ipsHide' id='elCart_sep'><\/li>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction cartHeaderMobile(  ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\n$location = NULL;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( isset( $_SESSION['cart'] ) and \\count( $_SESSION['cart'] ) and \\IPS\\Member::loggedIn()->canAccessModule( \\IPS\\Application\\Module::get( 'nexus', 'store' ) ) ):\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\n$subtotal = 0;\n$return .= <<<CONTENT\n\n\t<li class='cUserNav_icon'>\n\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n'>\n\t\t\t<span class='ipsNotificationCount'>\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\nexus\\Application::cartCount(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<i class='fa fa-shopping-cart'><\/i>\n\t\t<\/a>\n\t<\/li>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction cartReview( $package, $quantity, $upsell ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->pixel( array( 'AddToCart' => array( 'content_type' => 'product', 'content_ids' => array( $package->id ) ) ) );\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( \\IPS\\Request::i()->registerCheckout ):\n$return .= <<<CONTENT\n\n\t<div class='ipsType_center ipsPad ipsType_light ipsType_large ipsBox'>\n\t\t\nCONTENT;\n\n$sprintf = array($package->_title); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_added_to_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t<br><br>\n\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' class='ipsButton ipsButton_medium ipsButton_primary'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'continue_to_registration', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t<\/div>\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t<div class='ipsPad'>\n\t \t<div class='ipsAreaBackground_light ipsPad ipsType_center ipsSpacer_bottom'>\n\t\t\t<h3 class='ipsType_sectionHead ipsType_center ipsSpacer_bottom ipsSpacer_half ipsType_success'><i class='fa fa-check-circle-o'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_added_to_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h3>\n\t\t\t<h4 class='ipsType_reset ipsType_large'>\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t<p class='ipsType_reset ipsType_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'quantity', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n: \nCONTENT;\n$return .= htmlspecialchars( $quantity, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/p>\n\t\t<\/div>\n\t\t<ul class='ipsGrid ipsGrid_collapsePhone'>\n\t\t\t<li class='ipsGrid_span6'>\n\t\t\t\t<a href='#' data-action='dialogClose' class='ipsButton ipsButton_fullWidth ipsButton_light ipsButton_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'continue_shopping', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t<\/li>\n\t\t\t<li class='ipsGrid_span6'>\n\t\t\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n' title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'review_cart_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\" class='ipsButton ipsButton_fullWidth ipsButton_primary ipsButton_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'review_and_checkout', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t<\/li>\n\t\t<\/ul>\n\t\t\nCONTENT;\n\nif ( \\count( $upsell ) ):\n$return .= <<<CONTENT\n\n\t\t\t<hr class='ipsHr'>\n\t\t\t<h2 class='ipsType_sectionHead'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'related_products_you_might_like', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t<div class='ipsCarousel ipsClearfix ipsSpacer_top' data-ipsCarousel data-ipsCarousel-showDots>\n\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t<ul class='cNexusCarousel cNexusCategory_grid ipsClearfix' data-role=\"carouselItems\">\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $upsell as $upsellPackage ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $upsellPackage, TRUE, TRUE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction category( $category, $subcategories, $packages, $pagination, $packagesWithCustomFields, $totalCount ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<header class=\"ipsPageHeader ipsBox ipsPadding ipsResponsive_pull ipsClearfix ipsSpacer_bottom\">\n\t<h1 class=\"ipsType_pageTitle ipsType_largeTitle\">\nCONTENT;\n$return .= htmlspecialchars( $category->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h1>\n\t\nCONTENT;\n\nif ( $category->description ):\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\", 'global' )->richText( $category->description, array('ipsType_normal') );\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\t\t\n<\/header>\n\n\nCONTENT;\n\nif ( \\count( $subcategories ) ):\n$return .= <<<CONTENT\n\n\t<section class='ipsBox ipsResponsive_pull ipsPadding'>\n\t\t<ul class='ipsGrid ipsGrid_collapsePhone' data-ipsGrid data-ipsGrid-minItemSize='200' data-ipsGrid-maxItemSize='350' data-ipsGrid-equalHeights='row'>\n\t\t\t\nCONTENT;\n\nforeach ( $subcategories as $group ):\n$return .= <<<CONTENT\n\n\t\t\t\t<li class='ipsGrid_span4 cNexusCategoryBlock'>\n\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $group->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-grid-ratio='40' \nCONTENT;\n\nif ( $group->image ):\n$return .= <<<CONTENT\nstyle=\"background-image: url( '\nCONTENT;\n\n$return .= htmlspecialchars( str_replace( array( '(', ')' ), array( '\\(', '\\)' ), $group->image ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' );\"\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\n\t\t\t\t\t\t<h2 class='ipsType_sectionHead ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $group->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t<\/a>\n\t\t\t\t<\/li>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t<\/ul>\n\t<\/section>\n\t<br>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n<div data-role=\"packageListContainer\">\n\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->categoryContents( $category, $subcategories, $packages, $pagination, $packagesWithCustomFields, $totalCount );\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction categoryContents( $category, $subcategories, $packages, $pagination, $packagesWithCustomFields, $totalCount ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( \\count( $packages ) ):\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\n$view = isset( \\IPS\\Request::i()->cookie['storeView'] ) ? \\IPS\\Request::i()->cookie['storeView'] : \\IPS\\Theme::i()->settings['cm_store_view'];\n$return .= <<<CONTENT\n\n\t<section class='ipsBox'>\n\t\t<h2 class='ipsType_sectionTitle ipsType_reset'><span class='ipsType_medium'>\nCONTENT;\n\n$pluralize = array( $totalCount ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'products_count', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span><\/h2>\n\t\t<div class=\"ipsButtonBar ipsPad_half ipsClearfix ipsClear\">\n\t\t\t<ul class=\"ipsButtonRow ipsPos_right ipsClearfix\">\n\t\t\t\t<li>\n\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $category->url()->setQueryString( 'view', 'grid' )->csrf(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_products_grid', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' class=\"\nCONTENT;\n\nif ( $view == 'grid' ):\n$return .= <<<CONTENT\nipsButtonRow_active\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\"><i class=\"fa fa-th-large\"><\/i><\/a>\n\t\t\t\t<\/li>\n\t\t\t\t<li>\n\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $category->url()->setQueryString( 'view', 'list' )->csrf(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_products_list', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' class='\nCONTENT;\n\nif ( $view == 'list' ):\n$return .= <<<CONTENT\nipsButtonRow_active\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'><i class=\"fa fa-th-list\"><\/i><\/a>\n\t\t\t\t<\/li>\n\t\t\t<\/ul>\n\t\t\t<ul class=\"ipsButtonRow ipsPos_right ipsClearfix\">\n\t\t\t\t<li>\n\t\t\t\t\t<a href=\"#elSortByMenu_menu\" id=\"elSortByMenu_products\" data-role=\"sortButton\" data-ipsMenu data-ipsMenu-activeclass=\"ipsButtonRow_active\" data-ipsMenu-selectable=\"radio\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'sort_by', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <i class=\"fa fa-caret-down\"><\/i><\/a>\n\t\t\t\t\t<ul class=\"ipsMenu ipsMenu_auto ipsMenu_withStem ipsMenu_selectable ipsHide\" id=\"elSortByMenu_products_menu\">\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( array( 'default', 'name', 'price_low', 'price_high', 'rating' ) as $k ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li class=\"ipsMenu_item \nCONTENT;\n\nif ( ( \\IPS\\Request::i()->sortby and \\IPS\\Request::i()->sortby == $k ) or ( !\\IPS\\Request::i()->sortby and $k === 'default' ) ):\n$return .= <<<CONTENT\nipsMenu_itemChecked\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" data-ipsmenuvalue=\"\nCONTENT;\n$return .= htmlspecialchars( $k, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $k === 'default' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $category->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $category->url()->setQueryString( 'sortby', $k ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$val = \"products_sort_{$k}\"; $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( $val, ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/li>\n\t\t\t<\/ul>\n\t\t\t\nCONTENT;\n\nif ( $pagination ):\n$return .= <<<CONTENT\n\n\t\t\t\t{$pagination}\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t\nCONTENT;\n\nif ( \\count( $packages ) ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $view == 'list' ):\n$return .= <<<CONTENT\n\n\t\t\t\t<ol class='ipsDataList ipsDataList_large cNexusCategory_list' data-role=\"packageList\">\n\t\t\t\t\t\nCONTENT;\n\nforeach ( $packages as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageRow( $package, \\in_array( $package->id, $packagesWithCustomFields ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/ol>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsPad'>\n\t\t\t\t\t<ol class='ipsGrid ipsGrid_collapsePhone cNexusCategory_grid' data-ipsGrid data-ipsGrid-minItemSize='170' data-ipsGrid-maxItemSize='230' data-ipsGrid-equalHeights='row' data-role=\"packageList\">\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $packages as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $package );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ol>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( trim( $pagination ) != '' ):\n$return .= <<<CONTENT\n\n\t\t\t<div class=\"ipsButtonBar ipsPad_half ipsClearfix ipsClear\">\n\t\t\t\t{$pagination}\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/section>\n\nCONTENT;\n\nelseif ( ( !\\count( $subcategories ) ) ):\n$return .= <<<CONTENT\n\n\t<div class=\"ipsPad ipsPad_double ipsType_center ipsType_light ipsType_large\" data-role=\"packageList\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_empty', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction categorySidebar( $category=NULL, $subcategories=NULL, $url=NULL, $havePackages=FALSE, $currency=NULL, $havePackagesWhichAcceptReviews = FALSE, $havePackagesWhichUseStockLevels = FALSE ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div data-role=\"categorySidebar\">\n\t\nCONTENT;\n\nif ( !\\IPS\\nexus\\Package\\Group::theOnlyNode( array(), TRUE, FALSE ) ):\n$return .= <<<CONTENT\n\n\t<div class='ipsBox ipsSpacer_bottom' id='elNexusCategoriesBox'>\n\t\t<h2 class='ipsType_sectionTitle ipsType_reset'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'categories', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t<div class='ipsPad_half'>\n\t\t\t\nCONTENT;\n\nif ( $subcategories !== NULL AND \\count( $subcategories ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsSideMenu ipsSideMenu_withRadios ipsType_medium' id='elCategories_menu'>\n\t\t\t\t\t<h3 class='ipsSideMenu_mainTitle ipsAreaBackground_light ipsType_medium'>\n\t\t\t\t\t\t<a href='#elCategories_menu' class='ipsPad_double' data-action='openSideMenu'><i class='fa fa-bars'><\/i> &nbsp;\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'categories', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n&nbsp;<i class='fa fa-caret-down'><\/i><\/a>\n\t\t\t\t\t<\/h3>\n\t\t\t\t\t<p class='ipsType_reset ipsType_medium cNexusCategoriesBox_back'>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $category && $category->parent() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $category->parent()->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsType_medium'><i class='fa fa-chevron-left'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $category->parent()->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=store\", null, \"store\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n'><i class='fa fa-chevron-left'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'all_categories', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/p>\n\t\t\t\t\t<hr class='ipsHr'>\n\t\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n$return .= htmlspecialchars( $category->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $subcategories as $idx => $subcategory ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $subcategory->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item'><strong>\nCONTENT;\n$return .= htmlspecialchars( $subcategory->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $subcategory->hasSubgroups() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $subcategory->children( 'view', NULL, FALSE ) as $cidx => $child ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $cidx >= 5 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $subcategory->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item'><span class='ipsType_light ipsType_small'>\nCONTENT;\n\n$pluralize = array( \\count( $subcategory->children( 'view', NULL, FALSE ) ) - 5 ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'and_x_more', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span><\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nbreak;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $child->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $child->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nelseif ( $category && $category->parent() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$siblings = $category->parent()->children( 'view', NULL, FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsSideMenu ipsSideMenu_withRadios ipsType_medium' id='elCategories_menu'>\n\t\t\t\t\t<h3 class='ipsSideMenu_mainTitle ipsAreaBackground_light ipsType_medium'>\n\t\t\t\t\t\t<a href='#elCategories_menu' class='ipsPad_double' data-action='openSideMenu'><i class='fa fa-bars'><\/i> &nbsp;\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'categories', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n&nbsp;<i class='fa fa-caret-down'><\/i><\/a>\n\t\t\t\t\t<\/h3>\n\t\t\t\t\t<p class='ipsType_reset ipsType_medium cNexusCategoriesBox_back'>\n\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $category->parent()->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsType_medium'><i class='fa fa-chevron-left'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $category->parent()->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t<\/p>\n\t\t\t\t\t<hr class='ipsHr'>\n\t\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n$return .= htmlspecialchars( $category->parent()->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $siblings as $idx => $sibling ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $sibling->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item \nCONTENT;\n\nif ( $category && $category == $sibling ):\n$return .= <<<CONTENT\nipsSideMenu_itemActive\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $sibling->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $sibling instanceof \\IPS\\nexus\\Package\\Group && $sibling->hasSubgroups() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$cidx = 0;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $sibling->children( 'view', NULL, FALSE ) as $child ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $child->hasPackages( NULL, array(), TRUE ) OR $child->hasSubgroups() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$cidx++;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $cidx >= 5 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $sibling->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item'><span class='ipsType_light ipsType_small'>\nCONTENT;\n\n$pluralize = array( \\count( $sibling->children( 'view', NULL, FALSE ) ) - 5 ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'and_x_more', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span><\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nbreak;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $child->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $child->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsSideMenu ipsSideMenu_withRadios ipsType_medium' id='elCategories_menu'>\n\t\t\t\t\t<h3 class='ipsSideMenu_mainTitle ipsAreaBackground_light ipsType_medium'>\n\t\t\t\t\t\t<a href='#elCategories_menu' class='ipsPad_double' data-action='openSideMenu'><i class='fa fa-bars'><\/i> &nbsp;\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'categories', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n&nbsp;<i class='fa fa-caret-down'><\/i><\/a>\n\t\t\t\t\t<\/h3>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( \\IPS\\nexus\\Package\\Group::rootsWithViewablePackages() as $group ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $group->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item \nCONTENT;\n\nif ( $category && $category == $group ):\n$return .= <<<CONTENT\nipsSideMenu_itemActive\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'><strong>\nCONTENT;\n$return .= htmlspecialchars( $group->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $group->hasSubgroups() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$idx = 0;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $group->children( 'view', NULL, FALSE ) as $child ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $child->hasPackages( NULL, array(), TRUE ) OR $child->hasSubgroups() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$idx++;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $idx >= 5 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $group->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item'><span class='ipsType_light ipsType_small'>\nCONTENT;\n\n$pluralize = array( \\count( $group->children( 'view', NULL, FALSE ) ) - 5 ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'and_x_more', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span><\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nbreak;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $child->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $child->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\n\t\nCONTENT;\n\nif ( $havePackages or \\IPS\\Request::i()->filter or \\IPS\\Request::i()->minPrice or \\IPS\\Request::i()->maxPrice or \\IPS\\Request::i()->minRating or \\IPS\\Request::i()->inStock ):\n$return .= <<<CONTENT\n\n\t<div class='ipsBox ipsSpacer_bottom' id='elNexusFiltersBox'>\n\t\t\n\t\t<h2 class='ipsType_sectionTitle ipsType_reset'>\n\t\t\t\nCONTENT;\n\nif ( \\IPS\\Request::i()->filter or \\IPS\\Request::i()->minPrice or \\IPS\\Request::i()->maxPrice or \\IPS\\Request::i()->minRating or \\IPS\\Request::i()->inStock ):\n$return .= <<<CONTENT\n\n\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $category->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-action=\"filter\" class=\"ipsPos_right ipsButton ipsButton_veryLight ipsButton_veryVerySmall ipsSideMenu_titleExtra\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_clear_filters', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_filter_by', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t<\/h2>\n\t\t<div class='ipsPad_half'>\n\t\t\t\nCONTENT;\n\nforeach ( $category->filters( \\IPS\\Member::loggedIn()->language() ) as $filterId => $values ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class=\"ipsSideMenu ipsSideMenu_withRadios ipsType_medium\">\n\t\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n\n$val = \"nexus_product_filter_{$filterId}_public\"; $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( $val, ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $values as $valueId => $value ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$active = ( isset( \\IPS\\Request::i()->filter[ $filterId ] ) and \\in_array( $valueId, explode( ',', \\IPS\\Request::i()->filter[ $filterId ] ) ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n\nif ( $active ):\n$return .= <<<CONTENT\n\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'filter', \\IPS\\nexus\\Package\\Filter::queryString( \\IPS\\Request::i()->filter, $filterId, NULL, $valueId ) ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'filter', \\IPS\\nexus\\Package\\Filter::queryString( \\IPS\\Request::i()->filter, $filterId, $valueId ) ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line \nCONTENT;\n\nif ( $active ):\n$return .= <<<CONTENT\nipsSideMenu_itemActive\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $value, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t<div class=\"ipsSideMenu ipsSideMenu_withRadios ipsType_medium\">\n\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'price', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\nCONTENT;\n\n$haveCategoryPriceFilters = ( $category->price_filters and $priceFilters = json_decode( $category->price_filters, TRUE ) and isset( $priceFilters[ $currency ] ) and \\count( $priceFilters[ $currency ] ) ); $lastAmount = 0; $activePriceFilter = FALSE;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nif ( $haveCategoryPriceFilters ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $priceFilters[ $currency ] as $amount ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $lastAmount ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Request::i()->minPrice and \\IPS\\Request::i()->maxPrice and \\IPS\\Request::i()->minPrice == $lastAmount and \\IPS\\Request::i()->maxPrice == $amount ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$activePriceFilter = TRUE;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minPrice', NULL )->setQueryString( 'maxPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line ipsSideMenu_itemActive'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minPrice', $lastAmount )->setQueryString( 'maxPrice', $amount ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $lastAmount, $currency );\n$return .= <<<CONTENT\n&ndash;\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $amount, $currency );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Request::i()->maxPrice and \\IPS\\Request::i()->maxPrice == $amount and !\\IPS\\Request::i()->minPrice ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$activePriceFilter = TRUE;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'maxPrice', NULL )->setQueryString( 'minPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line ipsSideMenu_itemActive'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'maxPrice', $amount )->setQueryString( 'minPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( 0, $currency );\n$return .= <<<CONTENT\n&ndash;\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $amount, $currency );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$lastAmount = $amount;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Request::i()->minPrice and \\IPS\\Request::i()->minPrice == $lastAmount and !\\IPS\\Request::i()->maxPrice ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$activePriceFilter = TRUE;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minPrice', NULL )->setQueryString( 'maxPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line ipsSideMenu_itemActive'>\n\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minPrice', $lastAmount )->setQueryString( 'maxPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( $lastAmount, $currency );\n$return .= <<<CONTENT\n+\n\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nif ( !$activePriceFilter and ( \\IPS\\Request::i()->minPrice or \\IPS\\Request::i()->maxPrice ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minPrice', NULL )->setQueryString( 'maxPrice', NULL ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsSideMenu_item ipsTruncate ipsTruncate_line ipsSideMenu_itemActive'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Request::i()->minPrice and \\IPS\\Request::i()->maxPrice ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( \\IPS\\Request::i()->minPrice, $currency );\n$return .= <<<CONTENT\n&ndash;\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( \\IPS\\Request::i()->maxPrice, $currency );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelseif ( \\IPS\\Request::i()->minPrice ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( \\IPS\\Request::i()->minPrice, $currency );\n$return .= <<<CONTENT\n+\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( 0, $currency );\n$return .= <<<CONTENT\n&ndash;\nCONTENT;\n\n$return .= new \\IPS\\nexus\\Money( \\IPS\\Request::i()->maxPrice, $currency );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t<\/li>\t\t\t\t\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'do', 'priceFilter' ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-ipsDialog data-ipsDialog-size=\"narrow\" data-ipsDialog-title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'price_filter_set', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line'>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'custom_price_filter', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/a>\n\t\t\t\t\t<\/li>\t\t\t\t\n\t\t\t\t<\/ul>\n\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nif ( $havePackagesWhichAcceptReviews ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class=\"ipsSideMenu ipsSideMenu_withRadios ipsType_medium\">\n\t\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'minRating', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( range( 5, 1 ) as $minRating ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'minRating', \\IPS\\Request::i()->minRating == $minRating ? NULL : $minRating ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line \nCONTENT;\n\nif ( \\IPS\\Request::i()->minRating and \\IPS\\Request::i()->minRating == $minRating ):\n$return .= <<<CONTENT\nipsSideMenu_itemActive\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'large', $minRating, \\IPS\\Settings::i()->reviews_rating_out_of );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $havePackagesWhichUseStockLevels ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class=\"ipsSideMenu ipsSideMenu_withRadios ipsType_medium\">\n\t\t\t\t\t<h4 class='ipsSideMenu_title ipsSpacer_top ipsSpacer_half'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t<ul class='ipsSideMenu_list'>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<a data-action=\"filter\" href=\"\nCONTENT;\n$return .= htmlspecialchars( $url->setQueryString( 'inStock', \\IPS\\Request::i()->inStock ? NULL : 1 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsSideMenu_item ipsTruncate ipsTruncate_line \nCONTENT;\n\nif ( \\IPS\\Request::i()->inStock ):\n$return .= <<<CONTENT\nipsSideMenu_itemActive\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'in_stock_only', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->chooseCurrency( $category ? $category->url() : \\IPS\\Http\\Url::internal('app=nexus&module=store&controller=store', 'front', 'store') );\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction chooseCurrency( $baseUrl ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( \\count( \\IPS\\nexus\\Money::currencies() ) > 1 ):\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\n$memberCurrency = ( ( isset( \\IPS\\Request::i()->cookie['currency'] ) and \\in_array( \\IPS\\Request::i()->cookie['currency'], \\IPS\\nexus\\Money::currencies() ) ) ? \\IPS\\Request::i()->cookie['currency'] : \\IPS\\nexus\\Customer::loggedIn()->defaultCurrency() );\n$return .= <<<CONTENT\n\n\t<div class='ipsType_center ipsBox ipsPadding ipsSpacer_top ipsSpacer_half' \nCONTENT;\n\nif ( isset( $_SESSION['cart'] ) and \\count( $_SESSION['cart'] ) ):\n$return .= <<<CONTENT\ndata-controller=\"nexus.front.store.currencySelect\"\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\n\t\t<span class='ipsType_normal'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'show_prices_in', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t<ul class='ipsList_inline'>\n\t\t\t\nCONTENT;\n\nforeach ( \\IPS\\nexus\\Money::currencies() as $currency ):\n$return .= <<<CONTENT\n\n\t\t\t\t<li>\n\t\t\t\t\t\nCONTENT;\n\nif ( $currency == $memberCurrency ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $baseUrl->setQueryString( 'currency', $currency )->csrf(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsType_blendLinks' title='\nCONTENT;\n\n$sprintf = array($currency); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'set_currency_to', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t<strong><i class='fa fa-check'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $currency, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<a data-action=\"filter\" href='\nCONTENT;\n$return .= htmlspecialchars( $baseUrl->setQueryString( 'currency', $currency )->csrf(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($currency); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'set_currency_to', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $currency, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/li>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t<\/ul>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction domainBuy( $field, $prices ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\nhttp:\/\/ <input type=\"text\" name=\"\nCONTENT;\n$return .= htmlspecialchars( $field->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n[sld]\" value=\"\nCONTENT;\n$return .= htmlspecialchars( $field->value['sld'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\"> . <select name=\"\nCONTENT;\n$return .= htmlspecialchars( $field->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n[tld]\">\nCONTENT;\n\nforeach ( $prices as $tld => $price ):\n$return .= <<<CONTENT\n<option value=\"\nCONTENT;\n$return .= htmlspecialchars( $tld, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" \nCONTENT;\n\nif ( $tld == $field->value['tld'] ):\n$return .= <<<CONTENT\nselected\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\nCONTENT;\n$return .= htmlspecialchars( $tld, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n (\nCONTENT;\n$return .= htmlspecialchars( $price, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n)<\/option>\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n<\/select>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction domainSub( $field ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\nhttp:\/\/ <input type=\"text\" name=\"\nCONTENT;\n$return .= htmlspecialchars( $field->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n[subdomain]\" value=\"\nCONTENT;\n\nif ( isset( $field->value['subdomain'] ) ):\n$return .= <<<CONTENT\n\nCONTENT;\n$return .= htmlspecialchars( $field->value['subdomain'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\"> . <select name=\"\nCONTENT;\n$return .= htmlspecialchars( $field->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n[domain]\">\nCONTENT;\n\nforeach ( explode( ',', \\IPS\\Settings::i()->nexus_hosting_subdomains ) as $domain ):\n$return .= <<<CONTENT\n<option value=\"\nCONTENT;\n$return .= htmlspecialchars( $domain, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" \nCONTENT;\n\nif ( isset( $field->value['domain'] ) AND $domain == $field->value['domain'] ):\n$return .= <<<CONTENT\nselected\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\nCONTENT;\n$return .= htmlspecialchars( $domain, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/option>\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n<\/select>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction giftCard( $form ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div class=\"ipsPageHeader ipsClearfix ipsSpacer_bottom cForumHeader\">\n\t<ul class=\"ipsToolList ipsToolList_horizontal ipsClearfix ipsPos_right\">\n\t\t<li class=\"ipsToolList_primaryAction ipsResponsive_hidePhone\">\n\t\t\t<a href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=gifts&do=redeem\", null, \"store_giftvouchers_redeem\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" data-ipsDialog data-ipsDialog-size='narrow' data-ipsDialog-title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'redeem_gift_voucher', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' class='ipsButton ipsButton_medium ipsButton_primary'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'redeem_gift_voucher', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t<\/ul>\n\t<h1 class=\"ipsType_pageTitle\">\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'buy_gift_voucher', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t<\/h1>\n<\/div>\n\n<div class='ipsBox ipsPadding:double' data-controller='nexus.front.store.giftCard' data-formatCurrencyUrl=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=gifts&do=formatCurrency\", null, \"\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\">\n\t{$form}\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction giftCardForm( $id, $action, $elements, $hiddenValues, $actionButtons, $uploadField, $class='', $attributes, $sidebar, $form ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $form->error ):\n$return .= <<<CONTENT\n\n\t<div class=\"ipsMessage ipsMessage_error ipsSpacer_bottom\">\n\t\t\nCONTENT;\n$return .= htmlspecialchars( $form->error, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<form accept-charset='utf-8' class=\"ipsForm \nCONTENT;\n$return .= htmlspecialchars( $class, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" action=\"\nCONTENT;\n$return .= htmlspecialchars( $action, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" method=\"post\" \nCONTENT;\n\nif ( $uploadField ):\n$return .= <<<CONTENT\nenctype=\"multipart\/form-data\"\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n data-ipsForm>\n\t<input type=\"hidden\" name=\"\nCONTENT;\n$return .= htmlspecialchars( $id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_submitted\" value=\"1\">\n\t\nCONTENT;\n\nforeach ( $hiddenValues as $k => $v ):\n$return .= <<<CONTENT\n\n\t\t<input type=\"hidden\" name=\"\nCONTENT;\n$return .= htmlspecialchars( $k, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" value=\"\nCONTENT;\n$return .= htmlspecialchars( $v, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $uploadField ):\n$return .= <<<CONTENT\n\n\t\t<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"\nCONTENT;\n$return .= htmlspecialchars( $uploadField, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t<input type=\"hidden\" name=\"plupload\" value=\"\nCONTENT;\n\n$return .= htmlspecialchars( md5( mt_rand() ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<div class='ipsGrid ipsGrid_collapsePhone'>\n\t\t<div class='ipsGrid_span6'>\n\t\t\t<div class=\"ipsColumns ipsColumns_collapsePhone cNexusStep_block\">\n\t\t\t\t<div class=\"ipsColumn ipsColumn_veryNarrow\">\n\t\t\t\t\t<span class=\"cNexusStep_step\">1<\/span>\n\t\t\t\t<\/div>\n\t\t\t\t<div class=\"ipsColumn ipsColumn_fluid\">\n\t\t\t\t\t<h2 class=\"ipsType_sectionHead\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_personalize', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t<p class=\"ipsType_normal ipsType_reset\">\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_personalize_desc', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/p>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t\t<hr class='ipsHr'>\n\t\t\t<ul class='ipsForm ipsForm_vertical'>\n\t\t\t\t<li class=\"ipsFieldRow ipsClearfix\">\n\t\t\t\t\t<div class=\"ipsFieldRow_content\">\t\n\t\t\t\t\t\t<input type='hidden' name='gift_voucher_color' value='\nCONTENT;\n\n$return .= htmlspecialchars( str_replace( '#', '', $elements['']['gift_voucher_color']->value ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t<ul class='ipsList_inline ipsList_noSpacing cNexusGiftcard_swatches'>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='3b3b3b' style='background-color: #3b3b3b'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='16a085' style='background-color: #16a085'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='27ae60' style='background-color: #27ae60'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='2980b9' style='background-color: #2980b9'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='2c3e50' style='background-color: #2c3e50'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='8e44ad' style='background-color: #8e44ad'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='f39c12' style='background-color: #f39c12'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='d35400' style='background-color: #d35400'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='c0392b' style='background-color: #c0392b'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t\t<li class='ipsAreaBackground_light'><a href='#' data-color='7f8c8d' style='background-color: #7f8c8d'>&nbsp;<\/a><\/li>\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t<\/ul>\n\t\t\t<div id='elNexusGiftcard' class='ipsBox ipsBox--child ipsSpacer_top' data-role='giftCardArea'>\n\t\t\t\t<div id='elNexusGiftcard_card' data-role='giftCard'>\n\t\t\t\t\t<span data-role='icon'><i class='fa fa-gift'><\/i><\/span>\n\t\t\t\t\t<h2 class='ipsType_reset'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t<strong data-role='siteName'>\nCONTENT;\n\n$return .= \\IPS\\Settings::i()->board_name;\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t<strong data-role='value' class='cNexusGiftcard_content'><\/strong>\n\t\t\t\t\t<span data-role='redeem' class='cNexusGiftcard_redeem ipsResponsive_hidePhone'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_redeem', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t<\/div>\n\t\t\t\t<div class='ipsPad' id='elNexusGiftcard_personalize'>\n\t\t\t\t\t<div class='ipsType_normal cNexusGiftcard_content' data-role='to'>\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'to', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <input type='text' name='gift_voucher_recipient' value='\nCONTENT;\n$return .= htmlspecialchars( $elements['']['gift_voucher_recipient']->value, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' placeholder=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_recipient', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\">,\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsType_normal cNexusGiftcard_content ipsSpacer_both' data-role='message'>\n\t\t\t\t\t\t<textarea name='gift_voucher_message' rows='3' placeholder='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_message', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $elements['']['gift_voucher_message']->value, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/textarea>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsType_normal cNexusGiftcard_content'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'from', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <input type='text' name='gift_voucher_sender' value='\nCONTENT;\n$return .= htmlspecialchars( $elements['']['gift_voucher_sender']->value, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' placeholder='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_sender', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><\/div>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\t<div class='ipsGrid_span6'>\n\t\t\t<div class=\"ipsColumns ipsColumns_collapsePhone cNexusStep_block \">\n\t\t\t\t<div class=\"ipsColumn ipsColumn_veryNarrow\">\n\t\t\t\t\t<span class=\"cNexusStep_step\">2<\/span>\n\t\t\t\t<\/div>\n\t\t\t\t<div class=\"ipsColumn ipsColumn_fluid\">\n\t\t\t\t\t<h2 class=\"ipsType_sectionHead\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_choose_amount', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t<p class=\"ipsType_normal ipsType_reset\">\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gift_voucher_choose_amount_desc', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/p>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t\t<hr class='ipsHr'>\n\t\t\t<ul class='ipsForm ipsForm_vertical'>\n\t\t\t\t\nCONTENT;\n\nforeach ( $elements as $collection ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nforeach ( $collection as $inputName => $input ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nif ( !\\in_array( $inputName, array( 'gift_voucher_color', 'gift_voucher_recipient', 'gift_voucher_message', 'gift_voucher_sender') ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t{$input}\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t<\/ul>\n\n\t\t\t<div class='ipsType_left ipsSpacer_top'>\n\t\t\t\t<button type='submit' class='ipsButton ipsButton_large ipsButton_primary'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'add_gift_voucher_to_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/button>\n\t\t\t<\/div>\n\t\t<\/div>\n\t<\/div>\n<\/form>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction index( $credits, $newProducts, $popularProducts ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->pageHeader( \\IPS\\Member::loggedIn()->language()->addToStack('store') );\n$return .= <<<CONTENT\n\n\n\nCONTENT;\n\nif ( $credits->amount->isGreaterThanZero() ):\n$return .= <<<CONTENT\n\n\t<div class='ipsMessage ipsMessage_general'>\n\t\t\nCONTENT;\n\n$sprintf = array($credits); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_credit_message', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n<section>\n\t<ul class='ipsGrid ipsGrid_collapsePhone' data-ipsGrid data-ipsGrid-minItemSize='200' data-ipsGrid-maxItemSize='350' data-ipsGrid-equalHeights='row'>\n\t\t\nCONTENT;\n\nforeach ( \\IPS\\nexus\\Package\\Group::rootsWithViewablePackages() as $group ):\n$return .= <<<CONTENT\n\n\t\t\t<li class='ipsGrid_span4 cNexusCategoryBlock'>\n\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $group->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-grid-ratio='40' \nCONTENT;\n\nif ( $group->image ):\n$return .= <<<CONTENT\nstyle=\"background-image: url( '\nCONTENT;\n\n$return .= htmlspecialchars( str_replace( array( '(', ')' ), array( '\\(', '\\)' ), $group->image ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' );\"\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\n\t\t\t\t\t<h2 class='ipsType_sectionHead ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $group->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t<\/a>\n\t\t\t<\/li>\n\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t<\/ul>\n<\/section>\n\n<section class='ipsSpacer_top'>\n\nCONTENT;\n\nif ( \\count( \\IPS\\nexus\\Package\\Item::featured() ) ):\n$return .= <<<CONTENT\n\n\t<div class='ipsBox ipsSpacer_bottom'>\n\t\t<h2 class='ipsType_sectionTitle'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'featured_products', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t<div class='ipsPad'>\n\t\t\t<div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots>\n\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t<ul class='cNexusCarousel cNexusCategory_grid ipsClearfix' data-role=\"carouselItems\">\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( \\IPS\\nexus\\Package\\Item::featured() as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $package, TRUE, TRUE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t<\/div>\n\t\t<\/div>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\n\t\nCONTENT;\n\nif ( \\count( $newProducts ) ):\n$return .= <<<CONTENT\n\n\t\t<div class='ipsBox ipsSpacer_bottom'>\n\t\t\t<h2 class='ipsType_sectionTitle'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'new_products', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t<div class='ipsPad'>\n\t\t\t\t<div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots>\n\t\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t\t<ul class='cNexusCarousel cNexusCategory_grid ipsClearfix' data-role=\"carouselItems\">\n\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $newProducts as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $package, TRUE, TRUE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n\t\nCONTENT;\n\nif ( \\count( $popularProducts ) ):\n$return .= <<<CONTENT\n\n\t\t<div class='ipsBox ipsSpacer_bottom'>\n\t\t\t<h2 class='ipsType_sectionTitle'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'popular_products', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t<div class='ipsPad'>\n\t\t\t\t<div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots>\n\t\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t\t<ul class='cNexusCarousel cNexusCategory_grid ipsClearfix' data-role=\"carouselItems\">\n\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $popularProducts as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $package, TRUE, TRUE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/section>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction package( $package, $item, $purchaseForm, $inCart, $shippingMethods, $itemDataForShipping, $locationType, $renewalTerm, $initialTerm ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div>\n\t<div class='cNexusProduct_header ipsBox ipsResponsive_pull ipsColumns ipsColumns_collapsePhone' data-controller='nexus.front.store.packagePage' data-itemTitle=\"\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t<div class='ipsColumn ipsColumn_veryWide'>\n\t\t\t<div class='ipsPadding:double sm:ipsPadding'>\n\t\t\t\t<div class='ipsType_center ipsContained'>\n\t\t\t\t\t\nCONTENT;\n\nif ( $images = $item->images() and \\count( $images ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\n$donePrimary = false;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $images as $image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( !$donePrimary ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_primaryImage ipsContained' data-ipsLightbox data-ipsLightbox-group='product' data-ipsProductZoom><img src='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class=\"ipsImage ipsImage_thumb\"><\/a>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$donePrimary = true;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='cNexusProduct_images ipsSpacer_both'>\n\t\t\t\t\t\t\t<ul class='ipsList_inline ipsList_noSpacing'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $images as $image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-action='toggleImage' class='ipsAreaBackground_light'><img src='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class=\"ipsImage ipsImage_thumb ipsThumb_tiny\"><\/a>\n\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<span class='ipsType_small ipsType_light'><i class='fa fa-search-plus'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_zoom_desc', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='ipsNoThumb ipsThumb_large ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\t<div class='ipsColumn ipsColumn_fluid '>\n\t\t\t<div class='ipsPadding:double sm:ipsPadding'>\n\t\t\t\t<div class='ipsFlex ipsFlex-jc:between ipsFlex-ai:center ipsFlex-fw:wrap'>\n\t\t\t\t\t<h1 class='ipsType_pageTitle ipsType_largeTitle ipsMargin_right'>\nCONTENT;\n$return .= htmlspecialchars( $item->mapped('title'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h1>\n\t\t\t\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'large', $item->averageReviewRating(), \\IPS\\Settings::i()->reviews_rating_out_of, $item->memberReviewRating() );\n$return .= <<<CONTENT\n <span class='ipsType_medium'>(\nCONTENT;\n\n$pluralize = array( $item->reviews ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_reviews', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n)<\/span>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/div>\n\t\t\t\t\n\t\t\t\t\nCONTENT;\n\n$priceDetails = $package->fullPriceInfo();\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $priceDetails === NULL ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<em class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_no_price_info_desc', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/em>\n\t\t\t\t\t<\/div>\n\t\t\t\t\nCONTENT;\n\nelseif ( $priceDetails['initialTerm'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<ul class='ipsList_reset ipsSpacer_both ipsFlex ipsFlex-ai:center ipsFlex-fw:wrap'>\n\t\t\t\t\t\t<li class=\"ipsMargin_vertical:half ipsMargin_right:double\">\n\t\t\t\t\t\t\t<div>\nCONTENT;\n\n$sprintf = array($priceDetails['initialTerm']); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_initial_term_title', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n<\/div>\n\t\t\t\t\t\t\t<span class=\"cNexusPrice\">\n\t\t\t\t\t\t\t\t<span data-role=\"price\">\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['primaryPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $priceDetails['primaryPriceDiscountedFrom'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<s>\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['primaryPriceDiscountedFrom'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/s>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( !$priceDetails['primaryPriceIsZero'] and \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t<li class=\"ipsMargin_vertical:half\">\n\t\t\t\t\t\t\t<div>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_subsequent_term_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/div>\n\t\t\t\t\t\t\t<span class=\"cNexusPrice\">\n\t\t\t\t\t\t\t\t<span data-role=\"renewalTerm\">\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['renewalPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t<\/ul>\n\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t<span class=\"cNexusPrice ipsMargin_top\">\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $priceDetails['renewalPrice'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<span data-role=\"renewalTerm\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['renewalPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<span data-role=\"price\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['primaryPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $priceDetails['primaryPriceDiscountedFrom'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<s>\nCONTENT;\n$return .= htmlspecialchars( $priceDetails['primaryPriceDiscountedFrom'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/s>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/span>\n\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\n\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->nexus_show_stock and $package->stock != -1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<br><span data-role=\"stock\">\nCONTENT;\n\nif ( $package->stock == -2 ):\n$return .= <<<CONTENT\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\nCONTENT;\n\n$pluralize = array( $package->stock - $inCart ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'x_in_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n\t\t\t\t<div class='ipsType_richText ipsType_medium ipsType_break ipsContained ipsSpacer_top' data-ipsTruncate data-ipsTruncate-size='2 lines' data-ipsTruncate-type='remove'>\n\t\t\t\t\t{$item->truncated()}\n\t\t\t\t<\/div>\n\t\t\t\t<hr class='ipsHr'>\n\n\t\t\t\t<div class='ipsAreaBackground_light ipsPadding ipsSpacer_bottom'>\n\t\t\t\t\t{$purchaseForm}\n\t\t\t\t<\/div>\n\t\t\t\t\nCONTENT;\n\nif ( \\count( $item->shareLinks() ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"sharelinks\", \"core\" )->shareButton( $item );\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<\/div>\n\t\t<\/div>\n\t<\/div>\n\n\t<section class='ipsBox ipsResponsive_pull ipsSpacer_top'>\n\t\t<div class=\"ipsTabs ipsClearfix\" id=\"elProductTabs\" data-ipsTabBar data-ipsTabBar-contentArea=\"#elProductTabs_content\">\n\t\t\t<a href=\"#elProductTabs\" data-action=\"expandTabs\"><i class=\"fa fa-caret-down\"><\/i><\/a>\n\t\t\t<ul role=\"tablist\">\n\t\t\t\t<li>\n\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $item->url()->setQueryString('tab', 'info'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" id=\"elProductInfo\" class=\"ipsTabs_item ipsType_center \nCONTENT;\n\nif ( !isset( \\IPS\\Request::i()->tab ) OR \\IPS\\Request::i()->tab == 'info' ):\n$return .= <<<CONTENT\nipsTabs_activeItem\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" role=\"tab\" aria-selected=\"\nCONTENT;\n\nif ( !isset( \\IPS\\Request::i()->tab ) OR \\IPS\\Request::i()->tab == 'info' ):\n$return .= <<<CONTENT\ntrue\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nfalse\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_information', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nif ( $package->physical ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $item->url()->setQueryString('tab','shipping'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' id='elShipping' class='ipsTabs_item ipsType_center \nCONTENT;\n\nif ( \\IPS\\Request::i()->tab == 'shipping' ):\n$return .= <<<CONTENT\nipsTabs_activeItem\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' role=\"tab\" aria-selected=\"\nCONTENT;\n\nif ( \\IPS\\Request::i()->tab == 'shipping' ):\n$return .= <<<CONTENT\ntrue\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nfalse\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'shipping_information', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $item->url()->setQueryString('tab', 'reviews'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" id=\"elReviews\" class=\"ipsTabs_item ipsType_center \nCONTENT;\n\nif ( \\IPS\\Request::i()->tab == 'reviews' ):\n$return .= <<<CONTENT\nipsTabs_activeItem\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" role=\"tab\" aria-selected=\"\nCONTENT;\n\nif ( \\IPS\\Request::i()->tab == 'reviews' ):\n$return .= <<<CONTENT\ntrue\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nfalse\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_reviews_pl', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\t\t\t\n\t\t\t<\/ul>\n\t\t<\/div>\n\t\t<div id=\"elProductTabs_content\" class=\"ipsTabs_panels\">\n\t\t\t<div id=\"ipsTabs_elProductTabs_elProductInfo_panel\" class=\"ipsTabs_panel ipsAreaBackground_reset ipsPadding\" aria-hidden=\"false\">\n\t\t\t\t<h2 class='ipsType_sectionHead ipsSpacer_top'>\nCONTENT;\n\n$sprintf = array($item->mapped('title')); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'about_product', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\", 'global' )->richText( $package->description, array('ipsType_normal', 'ipsType_break', 'ipsContained', 'ipsSpacer_top') );\n$return .= <<<CONTENT\n\n\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nif ( $package->physical ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div id='ipsTabs_elProductTabs_elShipping_panel' class='ipsTabs_panel ipsAreaBackground_reset ipsPadding' aria-hidden='false'>\n\t\t\t\t\t\nCONTENT;\n\nif ( \\count( $shippingMethods ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<h2 class='ipsType_sectionHead ipsSpacer_top'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_shipping_options', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t\t<p class='ipsType_reset ipsType_medium ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_shipping_blurb', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/p>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $locationType != 'none' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<p class='ipsType_reset ipsType_medium ipsType_light'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $locationType == 'address' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_shipping_blurb_address', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'product_shipping_blurb_geo', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/p>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $itemDataForShipping ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<ul class='ipsDataList ipsDataList_reducedSpacing ipsSpacer_top'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $shippingMethods as $rate ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t\t\t\t\t\t<strong>\nCONTENT;\n\nif ( $rate->getPrice( array( $itemDataForShipping ), $itemDataForShipping->price->currency )->amount->isZero() ):\n$return .= <<<CONTENT\n<span class='ipsType_success'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'free_shipping', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\nCONTENT;\n$return .= htmlspecialchars( $rate->getPrice( array( $itemDataForShipping ), $itemDataForShipping->price->currency ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n<\/strong> - \nCONTENT;\n$return .= htmlspecialchars( $rate->getName(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\nCONTENT;\n\nif ( $estimatedDeliveryTime = $rate->getEstimatedDelivery( array( $itemDataForShipping ) ) ):\n$return .= <<<CONTENT\n <span class='ipsType_light'>(\nCONTENT;\n$return .= htmlspecialchars( $estimatedDeliveryTime, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n)<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<br>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<h2 class='ipsType_sectionHead'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'shipping_sizing', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h2>\n\t\t\t\t\t<ul class='ipsDataList ipsDataList_reducedSpacing ipsSpacer_top'>\n\t\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size3'>\n\t\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'size', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$length = new \\IPS\\nexus\\Shipping\\Length( $package->length );$return .= $length->string();\n$return .= <<<CONTENT\n &times; \nCONTENT;\n\n$length = new \\IPS\\nexus\\Shipping\\Length( $package->width );$return .= $length->string();\n$return .= <<<CONTENT\n &times; \nCONTENT;\n\n$length = new \\IPS\\nexus\\Shipping\\Length( $package->height );$return .= $length->string();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size3'>\n\t\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'weight', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$weight = new \\IPS\\nexus\\Shipping\\Weight( $package->weight );$return .= $weight->string();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div id=\"ipsTabs_elProductTabs_elReviews_panel\" class=\"ipsTabs_panel ipsAreaBackground_reset ipsPadding\" aria-hidden=\"false\">\n\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \"nexus\" )->reviews( $item );\n$return .= <<<CONTENT\n\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/section>\n<\/div>\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction packageBlock( $package, $grid=TRUE, $carousel=FALSE, $mini=FALSE ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<li class='\nCONTENT;\n\nif ( $grid ):\n$return .= <<<CONTENT\nipsGrid_span3\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n \nCONTENT;\n\nif ( $carousel ):\n$return .= <<<CONTENT\nipsCarousel_item\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n cNexusProduct \nCONTENT;\n\nif ( $mini ):\n$return .= <<<CONTENT\ncNexusProduct_mini\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n ipsPad_half ipsClearfix'>\n\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_image'>\n\t\t\nCONTENT;\n\nif ( $package->image ):\n$return .= <<<CONTENT\n\n\t\t<img src=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsImage'>\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<div class='ipsNoThumb ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/a>\n\t<div>\n\t\t<h2 class='cNexusProduct_title ipsType_normal ipsType_unbold ipsType_reset ipsType_blendLinks'>\n\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-role='productLink' class='\nCONTENT;\n\nif ( $carousel ):\n$return .= <<<CONTENT\nipsTruncate ipsTruncate_line\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/h2>\n\t\t<div class='ipsType_reset ipsTruncate ipsTruncate_line'>\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \"nexus\" )->packageBlockPrice( $package->fullPriceInfo() );\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t\nCONTENT;\n\nif ( $package->physical ):\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( $package->stock !== 0 ):\n$return .= <<<CONTENT\n\n\t\t<span class='ipsType_small cNexusStock cNexusStock_inStock'>\nCONTENT;\n\nif ( \\IPS\\Settings::i()->nexus_show_stock && $package->stock !== -1 && $package->stock !== -2 ):\n$return .= <<<CONTENT\n\nCONTENT;\n\n$pluralize = array( $package->stock ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'x_in_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'in_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n<\/span>\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<span class='ipsType_small cNexusStock cNexusStock_notInStock ipsType_warning'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'out_of_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t<div>\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'medium', $package->item()->averageReviewRating(), \\IPS\\Settings::i()->reviews_rating_out_of, $package->item()->memberReviewRating() );\n$return .= <<<CONTENT\n \nCONTENT;\n\nif ( !$mini ):\n$return .= <<<CONTENT\n<span class='ipsType_small'>(\nCONTENT;\n$return .= htmlspecialchars( $package->item()->reviews, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n)<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/div>\n<\/li>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction packageBlockPrice( $details ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<div class='cNexusProduct__prices'>\n\t\nCONTENT;\n\nif ( $details === NULL ):\n$return .= <<<CONTENT\n\n\t\t<div>\n\t\t\t<em class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_no_price_info', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/em>\n\t\t<\/div>\n\t\nCONTENT;\n\nelseif ( $details['primaryPriceIsZero'] AND $details['initialTerm'] ):\n$return .= <<<CONTENT\n\n\n\t\t<div>\n\t\t\t<span class=\"cNexusPrice\">\nCONTENT;\n$return .= htmlspecialchars( $details['renewalPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n\n\t\t\t\t<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t<div>\n\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $details['primaryPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $details['initialTerm'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$sprintf = array($details['initialTerm']); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_initial_term', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\n\t\t<div>\n\t\t\t<span class=\"cNexusPrice\">\n\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $details['primaryPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $details['primaryPriceDiscountedFrom'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<s>\nCONTENT;\n$return .= htmlspecialchars( $details['primaryPriceDiscountedFrom'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/s>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<\/span>\n\t\t\t\nCONTENT;\n\nif ( !$details['primaryPriceIsZero'] and \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n\n\t\t\t\t<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $details['initialTerm'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t<span>\nCONTENT;\n\n$sprintf = array($details['initialTerm']); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_initial_term', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t\nCONTENT;\n\nif ( $details['initialTerm'] ):\n$return .= <<<CONTENT\n\n\t\t<div>\n\t\t\t<div>\n\t\t\t\t<span class=\"cNexusPrice\">\nCONTENT;\n$return .= htmlspecialchars( $details['renewalPrice'], ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<span class='cNexusPrice_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<span>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'package_subsequent_term', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction packageBlockWidget( $package, $orientation='vertical', $mini=FALSE, $showAddToCart=FALSE ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<li class='ipsGrid_span3 \nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\nipsCarousel_item\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nipsDataItem\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n cNexusWidgetProduct \nCONTENT;\n\nif ( $mini ):\n$return .= <<<CONTENT\ncNexusProduct_mini\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n ipsPad_half ipsClearfix \nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\nipsSpacer_bottom\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_image ipsType_center'>\n\t\t\t\nCONTENT;\n\nif ( $package->image ):\n$return .= <<<CONTENT\n\n\t\t\t\t<img \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\nsrc='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Text\\Parser::blankImage(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\nsrc=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsImage'>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsNoThumb ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/a>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_image'>\n\t\t\t\nCONTENT;\n\nif ( $package->image ):\n$return .= <<<CONTENT\n\n\t\t\t\t<img \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\nsrc='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Text\\Parser::blankImage(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\nsrc=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsImage'>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsNoThumb ipsThumb_large ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/a>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<div>\n\t\t<div class='cNexusProduct_info ipsSpacer_top ipsSpacer_half'>\n\t\t\t<h2 class='cNexusProduct_title ipsType_normal ipsType_unbold ipsType_reset'>\n\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-role='productLink' class='\nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\nipsTruncate ipsTruncate_line\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t<\/h2>\n\t\t\t<p class='ipsType_reset ipsTruncate ipsTruncate_line cNexusPrice_widget'>\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \"nexus\" )->packageBlockPrice( $package->fullPriceInfo() );\n$return .= <<<CONTENT\n\n\t\t\t<\/p>\n\t\t\t\nCONTENT;\n\nif ( $package->physical ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$stockLevel = $package->stockLevel();\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $stockLevel === 0 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<span class='ipsType_small cNexusStock cNexusStock_notInStock ipsType_warning'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'out_of_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t<span class='ipsType_small cNexusStock cNexusStock_inStock'>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $stockLevel and \\IPS\\Settings::i()->nexus_show_stock ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$pluralize = array( $stockLevel ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'x_in_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'in_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/span>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div>\n\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'medium', $package->item()->averageReviewRating(), \\IPS\\Settings::i()->reviews_rating_out_of );\n$return .= <<<CONTENT\n<span class='ipsType_medium ipsType_light'>(\nCONTENT;\n$return .= htmlspecialchars( $package->item()->reviews, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n)<\/span>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/div>\n<\/li>\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction packageRow( $package, $hasCustomFields=FALSE ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<li class='ipsDataItem'>\n\t<div class='ipsDataItem_generic ipsDataItem_size5'>\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_image'>\n\t\t\t\nCONTENT;\n\nif ( $package->image ):\n$return .= <<<CONTENT\n\n\t\t\t\t<img src=\"\nCONTENT;\n$return .= htmlspecialchars( $package->image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsImage'>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsNoThumb ipsNoThumb_product'>&nbsp;<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/a>\n\t<\/div>\n\t<div class='ipsDataItem_main'>\n\t\t<h2 class='ipsDataItem_title ipsType_sectionHead ipsType_blendLinks'>\n\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $package->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class=\"ipsContained ipsType_break\">\n\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $package->featured ):\n$return .= <<<CONTENT\n<span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_positive\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'featured', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='fa fa-star'><\/i><\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<\/a>\n\t\t<\/h2>\n\t\t\nCONTENT;\n\nif ( $package->reviewable ):\n$return .= <<<CONTENT\n\n\t\t\t<div>\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'large', $package->item()->averageReviewRating(), \\IPS\\Settings::i()->reviews_rating_out_of, $package->item()->memberReviewRating() );\n$return .= <<<CONTENT\n <span class='ipsType_small'>(\nCONTENT;\n\n$pluralize = array( $package->item()->reviews ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_reviews', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n)<\/span>\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \"nexus\" )->packageBlockPrice( $package->fullPriceInfo() );\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$truncateAttributes = array('data-ipsTruncate', 'data-ipsTruncate-size=\"4 lines\"', 'data-ipsTruncate-type=\"remove\"');\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\", 'global' )->richText( $package->description, array('ipsType_medium', 'ipsType_break', 'ipsContained', 'ipsSpacer_top', 'ipsSpacer_half'), array(), $truncateAttributes );\n$return .= <<<CONTENT\n\n\t<\/div>\n\t<div class='ipsDataItem_generic ipsDataItem_size5 ipsPos_top ipsType_right'>\n\t\t<div class='ipsPad_half'>\n\t\t\t\nCONTENT;\n\nif ( $package->stock === 0 ):\n$return .= <<<CONTENT\n\n\t\t\t\t<span class='ipsButton ipsButton_primary ipsButton_verySmall ipsButton_narrow ipsButton_disabled ipsCursor_locked'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'out_of_stock', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $package->url()->setQueryString( 'purchase', 1 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsButton ipsButton_primary ipsButton_verySmall ipsButton_narrow' data-ipsDialog data-ipsDialog-size='medium' data-ipsDialog-title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_quick_view', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' data-ipsDialog-forceReload data-ipsDialog-destructOnClose='true'>\n\t\t\t\t\t<i class='fa fa-shopping-cart'><\/i>&nbsp;\n\t\t\t\t\t\nCONTENT;\n\nif ( $hasCustomFields ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'add_and_choose_options', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'add_to_cart', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/a>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t<\/div>\n<\/li>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction price( $price, $priceMayChange, $includePriceDescription=TRUE, $class='cNexusPrice' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $class !== NULL ):\n$return .= <<<CONTENT\n<span class='\nCONTENT;\n$return .= htmlspecialchars( $class, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $priceMayChange ):\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$sprintf = array($price); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'price_from', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n$return .= htmlspecialchars( $price, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $class !== NULL ):\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $includePriceDescription and \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n\n\t<span class='\nCONTENT;\n$return .= htmlspecialchars( $class, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction priceDiscounted( $original, $discounted, $priceMayChange, $includePriceDescription=TRUE, $class='cNexusPrice' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $class !== NULL ):\n$return .= <<<CONTENT\n<span class='\nCONTENT;\n$return .= htmlspecialchars( $class, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $priceMayChange ):\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$sprintf = array($discounted); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'price_from', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n$return .= htmlspecialchars( $discounted, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<s>\nCONTENT;\n$return .= htmlspecialchars( $original, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/s>\n\nCONTENT;\n\nif ( $class !== NULL ):\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( $includePriceDescription and \\IPS\\Member::loggedIn()->language()->checkKeyExists('nexus_tax_explain_val') ):\n$return .= <<<CONTENT\n\n\t<span class='\nCONTENT;\n$return .= htmlspecialchars( $class, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n_tax ipsType_light'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_tax_explain_val', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction purchaseForm( $package, $item, $purchaseForm ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div class='ipsPad' data-controller='nexus.front.store.packagePage' data-itemTitle=\"\nCONTENT;\n$return .= htmlspecialchars( $package->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t<div class='ipsColumns ipsColumns_collapsePhone'>\n\t\t<div class='ipsColumn ipsColumn_medium'>\n\t\t\t\nCONTENT;\n\nif ( $images = $item->images() and \\count( $images ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$donePrimary = false;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nforeach ( $images as $image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nif ( !$donePrimary ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='cNexusProduct_primaryImage ipsContained'><img src='\nCONTENT;\n$return .= htmlspecialchars( $image, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class=\"ipsImage ipsImage_thumb\"><\/a>\n\t\t\t\t\t\t\nCONTENT;\n\n$donePrimary = true;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\t<div class='ipsColumn ipsColumn_fluid'>\n\t\t\t<h1 class='ipsType_pageTitle'>\nCONTENT;\n$return .= htmlspecialchars( $item->mapped('title'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h1>\n\t\t\t<hr class='ipsHr'>\n\t\t\t{$purchaseForm}\n\t\t<\/div>\n\t<\/div>\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction register( $packages ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div class='ipsPad'>\n\t<br>\n\t<h1 class='ipsType_veryLarge ipsType_center ipsType_reset'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'sign_up', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n: \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'choose_product', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h1>\n\t<p class='ipsType_large ipsType_center ipsType_light'>\n\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->nexus_reg_force ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_forced_purchase', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'store_optional_purchase', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/p>\n\t\nCONTENT;\n\nif ( isset( $_SESSION['cart'] ) and \\count( $_SESSION['cart'] ) ):\n$return .= <<<CONTENT\n\n\t\t<p class='ipsType_large ipsType_center ipsType_light'>\n\t\t\t<a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=store&controller=cart\", null, \"store_cart\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'continue_to_registration', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <i class='fa fa-caret-right'><\/i><\/a>\n\t\t<\/p>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<br>\n\t\t\n\t<section data-controller='nexus.front.store.register'>\n\t\t<div class='ipsBox'>\n\t\t\t<div class='ipsPad_half'>\n\t\t\t\t<div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots data-role='productCarousel'>\n\t\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t\t<ul class='cNexusCarousel cNexusCategory_grid ipsClearfix' data-role=\"carouselItems\">\n\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $packages as $package ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"store\", \\IPS\\Request::i()->app )->packageBlock( $package, TRUE, TRUE, TRUE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t<\/div>\n\n\t\t<div data-role='productInformationWrapper' class='ipsHide cNexusRegister_info'>\n\t\t\t<hr class='ipsHr'>\n\t\t\t<a href='#' class='cNexusRegister_close ipsHide' data-action='closeInfo'>&times;<\/a>\n\t\t\t<div class='ipsSpacer_top' data-role='productInformation'><\/div>\n\t\t<\/div>\n\t<\/section>\n\t\n\t\nCONTENT;\n\nif ( !\\IPS\\Settings::i()->nexus_reg_force ):\n$return .= <<<CONTENT\n\n\t\t<p class='ipsType_right ipsType_normal'><a href='\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=core&module=system&controller=register&noPurchase=1\", null, \"register\", array(), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'continue_without_purchasing', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <i class='fa fa-caret-right'><\/i><\/a><\/p>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction reviews( $item ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<div data-controller='core.front.core.commentFeed' \nCONTENT;\n\nif ( \\IPS\\Settings::i()->auto_polling_enabled ):\n$return .= <<<CONTENT\ndata-autoPoll\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n data-baseURL='\nCONTENT;\n$return .= htmlspecialchars( $item->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' \nCONTENT;\n\nif ( $item->isLastPage('reviews') ):\n$return .= <<<CONTENT\ndata-lastPage\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n data-feedID='product-\nCONTENT;\n$return .= htmlspecialchars( $item->id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n-reviews' id='reviews'>\n\t\nCONTENT;\n\nif ( $item->reviewForm() ):\n$return .= <<<CONTENT\n\n\t\t<div id='elProductReviewForm'>\n\t\t\t{$item->reviewForm()}\n\t\t<\/div>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( $item->hasReviewed() ):\n$return .= <<<CONTENT\n\n\t\t\t<!-- Already reviewed -->\n\t\t\nCONTENT;\n\nelseif ( \\IPS\\Member::loggedin()->restrict_post ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->restrict_post == -1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"forms\", \"core\", 'front' )->reviewUnavailable( 'restricted_cannot_comment' );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"forms\", \"core\", 'front' )->reviewUnavailable( 'restricted_cannot_comment', \\IPS\\Member::loggedIn()->warnings(5,NULL,'rpa'), \\IPS\\Member::loggedIn()->restrict_post );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nelseif ( \\IPS\\Member::loggedIn()->members_bitoptions['unacknowledged_warnings'] ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"forms\", \"core\", 'front' )->reviewUnavailable( 'unacknowledged_warning_cannot_post', \\IPS\\Member::loggedIn()->warnings( 1, FALSE ) );\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $reviews = $item->reviews( NULL, NULL, NULL, 'desc', NULL, NULL, NULL, NULL, isset( \\IPS\\Request::i()->showDeleted ) ) AND \\count( $reviews ) ):\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( !$item->hasReviewed() ):\n$return .= <<<CONTENT\n<hr class='ipsHr'>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<div class=\"ipsClearfix ipsSpacer_bottom\">\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->commentMultimodHeader( $item, '#reviews', 'review' );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $item->reviewPageCount() > 1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class=\"ipsPos_left ipsResponsive_noFloat\">\n\t\t\t\t\t{$item->reviewPagination( array( 'tab', 'sort' ) )}\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<div class=\"ipsClearfix ipsPos_right ipsResponsive_hidePhone\">\n\t\t\t\t<ul class=\"ipsButtonRow ipsClearfix\">\n\t\t\t\t\t<li data-action=\"tableFilter\">\n\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $item->url()->setQueryString( array( 'tab' => 'reviews', 'sort' => 'helpful' ) )->setPage('page',1), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class=\"\nCONTENT;\n\nif ( !isset( \\IPS\\Request::i()->sort ) or \\IPS\\Request::i()->sort != 'newest' ):\n$return .= <<<CONTENT\nipsButtonRow_active\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" data-action=\"filterClick\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'most_helpful', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t<\/li>\n\t\t\t\t\t<li data-action=\"tableFilter\">\n\t\t\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $item->url()->setQueryString( array( 'tab' => 'reviews', 'sort' => 'newest' ) )->setPage('page',1), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class=\"\nCONTENT;\n\nif ( isset( \\IPS\\Request::i()->sort ) and \\IPS\\Request::i()->sort == 'newest' ):\n$return .= <<<CONTENT\nipsButtonRow_active\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" data-action=\"filterClick\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'newest', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t<\/li>\n\t\t\t\t<\/ul>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\t\n\t\t<div data-role='commentFeed' data-controller='core.front.core.moderation'>\n\t\t\t<form action=\"\nCONTENT;\n$return .= htmlspecialchars( $item->url()->csrf()->setQueryString( 'do', 'multimodReview' )->setPage('page',\\IPS\\Request::i()->page), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" method=\"post\" data-ipsPageAction data-role='moderationTools'>\n\t\t\t\t\nCONTENT;\n\nforeach ( $reviews as $review ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t{$review->html()}\n\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->commentMultimod( $item, 'review' );\n$return .= <<<CONTENT\n\n\t\t\t<\/form>\n\t\t<\/div>\n\t\t\nCONTENT;\n\nif ( $item->reviewPageCount() > 1 ):\n$return .= <<<CONTENT\n\n\t\t\t<div>\n\t\t\t\t{$item->reviewPagination( array( 'tab', 'sort' ) )}\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nelseif ( !$item->canReview() ):\n$return .= <<<CONTENT\n\n\t\t<p class=\"ipsType_normal ipsType_light ipsType_reset\" data-role=\"noReviews\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'no_reviews', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/p>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction subscriptionPurchase( $purchase ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\n<ul class='ipsList_inline'>\n\t<li>\n\t\t<strong class=\"ipsType_minorHeading\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'ps_start', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t<br>\nCONTENT;\n$return .= htmlspecialchars( $purchase->start->localeDate(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t<\/li>\n\t\nCONTENT;\n\nif ( $purchase->expire ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<strong class=\"ipsType_minorHeading\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'ps_expire', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t<br>\nCONTENT;\n$return .= htmlspecialchars( $purchase->expire->localeDate(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t<\/li>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $purchase->renewals and !$purchase->grouped_renewals ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<strong class=\"ipsType_minorHeading\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_renewal_terms', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t<br>\nCONTENT;\n$return .= htmlspecialchars( $purchase->renewals->toDisplay( $purchase->member ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t<\/li>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $purchase->billing_agreement AND !$purchase->billing_agreement->canceled ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<strong class=\"ipsType_minorHeading\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'ps_billing_agreement', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t<br><a href='\nCONTENT;\n$return .= htmlspecialchars( $purchase->billing_agreement->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class=\"ipsType_blendLinks\">\nCONTENT;\n$return .= htmlspecialchars( $purchase->billing_agreement->gw_id, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n<\/ul>\n\n<ul class='ipsList_inline ipsSpacer_top'>\n\t<li>\n\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $purchase->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class=\"ipsButton ipsButton_primary\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'nexus_subs_view_purchase', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t<\/li>\n\t\nCONTENT;\n\nif ( $pendingInvoice = $purchase->invoice_pending and $pendingInvoice->status === $pendingInvoice::STATUS_PENDING ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $pendingInvoice->checkoutUrl(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsButton ipsButton_important' title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_renew_now_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_renew_now', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t\nCONTENT;\n\nelseif ( $purchase->expire AND $canRenewUntil = $purchase->canRenewUntil(NULL,TRUE) ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<a href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=clients&controller=purchases&do=renew&id={$purchase->id}\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, \"front\", \"clientspurchaserenew\", array( \\IPS\\Http\\Url\\Friendly::seoTitle( $purchase->name ) ), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" class='ipsButton ipsButton_important' title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_renew_now_title', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\" \nCONTENT;\n\nif ( $canRenewUntil === TRUE or $canRenewUntil > 1 ):\n$return .= <<<CONTENT\ndata-ipsDialog data-ipsDialog-size='narrow'\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_renew_now', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $purchase->canCancel() ):\n$return .= <<<CONTENT\n\n\t\t<li>\n\t\t\t<a href=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Http\\Url::internal( \"app=nexus&module=clients&controller=purchases&do=cancel&id={$purchase->id}\" . \"&csrfKey=\" . \\IPS\\Session::i()->csrfKey, \"front\", \"clientspurchasecancel\", array( \\IPS\\Http\\Url\\Friendly::seoTitle( $purchase->name ) ), 0 ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', TRUE );\n$return .= <<<CONTENT\n\" class='ipsButton ipsButton_negative' data-confirm data-confirmSubMessage=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_cancel_renewal_confirm', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\">\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'purchase_cancel_renewal', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a>\n\t\t<\/li>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/ul>\n\nCONTENT;\n\n\t\treturn $return;\n}}"
VALUE;
