<?php

return <<<'VALUE'
"namespace IPS\\Theme;\nclass class_blog_front_widgets extends \\IPS\\Theme\\Template\n{\n\tpublic $cache_key = 'eb3f847938f9c2e3e1bf899066121da7';\n\tfunction blogCommentFeed( $comments, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $comments )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t<div class='ipsWidget_inner ipsPad_half'>\n\t\t\t<ul class='ipsDataList ipsDataList_reducedSpacing'>\n\t\t\t\t\nCONTENT;\n\nforeach ( $comments as $comment ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t<div class='ipsDataItem_icon ipsPos_top'>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->userPhoto( $comment->author(), 'tiny' );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t\t<div class='ipsType_break ipsContained'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsType_medium ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $comment->item()->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/div>\n\t\t\t\t\t\t\t<p class='ipsType_reset ipsType_medium ipsType_light ipsType_blendLinks'>\nCONTENT;\n\n$htmlsprintf = array($comment->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline_nodate', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n &middot; <a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsDataItem_title ipsType_break ipsType_blendLinks'>{$comment->dateLine()}<\/a><\/p>\n\t\t\t\t\t\t\t<div class='ipsType_medium ipsType_textBlock ipsType_richText ipsType_break ipsContained ipsSpacer_top ipsSpacer_half' data-ipsTruncate data-ipsTruncate-type='remove' data-ipsTruncate-size='\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n6 lines\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n2 lines\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t\t\t\t{$comment->truncated( true )}\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t<\/ul>\n\t\t<\/div>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<div class='ipsWidget_inner'>\n\t\t\t<ul class='ipsList_reset ipsPadding sm:ipsPadding:half'>\n\t\t\t\t\nCONTENT;\n\nforeach ( $comments as $comment ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li class='ipsBox ipsBox--child ipsClearfix ipsMargin_bottom'>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->reputation_enabled AND \\IPS\\IPS::classUsesTrait( $comment, 'IPS\\Content\\Reactable' ) and \\IPS\\Settings::i()->reputation_highlight and $comment->reactionCount() >= \\IPS\\Settings::i()->reputation_highlight ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<div class='ipsResponsive_showPhone ipsComment_badges'>\n\t\t\t\t\t\t\t\t<ul class='ipsList_inline'>\n\t\t\t\t\t\t\t\t\t<li><strong class='ipsBadge ipsBadge_large ipsBadge_popular'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'this_is_a_popular_comment', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong><\/li>\n\t\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='ipsComment_header ipsPhotoPanel ipsPhotoPanel_mini'>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->userPhoto( $comment->author(), 'mini', $comment->warningRef() );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->reputation_enabled AND \\IPS\\IPS::classUsesTrait( $comment, 'IPS\\Content\\Reactable' ) and \\IPS\\Settings::i()->reputation_highlight and $comment->reactionCount() >= \\IPS\\Settings::i()->reputation_highlight ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<div class='ipsPos_right ipsType_reset ipsType_light ipsType_blendLinks'>\n\t\t\t\t\t\t\t\t\t\t<ul class='ipsList_inline ipsComment_tools'>\n\t\t\t\t\t\t\t\t\t\t\t<li class='ipsResponsive_hidePhone'><strong class='ipsBadge ipsBadge_large ipsBadge_popular'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'this_is_a_popular_comment', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong><\/li>\n\t\t\t\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<h3 class='ipsComment_author ipsType_blendLinks'>\n\t\t\t\t\t\t\t\t\t<strong class='ipsType_normal'>\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->userLink( $comment->author(), $comment->warningRef() );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->reputationBadge( $comment->author() );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/h3>\n\t\t\t\t\t\t\t\t<p class='ipsComment_meta ipsType_light ipsType_medium'>\n\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $comment->item()->url()->setQueryString( array( 'do' => 'findComment', 'comment' => $comment->id ) ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsType_blendLinks'>{$comment->dateLine()}<\/a>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->editLine() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t(\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'edited_lc', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n)\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->hidden() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t&middot; \nCONTENT;\n$return .= htmlspecialchars( $comment->hiddenBlurb(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<\/p>\n\t\t\t\t\t\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Member::loggedIn()->modPermission('mod_see_warn') and $comment->warning ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->commentWarned( $comment );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/div>\n\n\t\t\t\t\t\t<div class='ipsPadding_vertical sm:ipsPadding_vertical:half ipsPadding_horizontal ipsClearfix'>\n\t\t\t\t\t\t\t<div class='ipsType_break ipsContained'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsDataItem_title ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $comment->item()->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/div><br>\n\t\t\t\t\t\t\t<div data-role='commentContent' class='ipsType_normal ipsType_richText ipsContained' data-controller='core.front.core.lightboxedImages'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->hidden() === 1 && $comment->author()->member_id == \\IPS\\Member::loggedIn()->member_id ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<strong class='ipsType_medium ipsType_warning'><i class='fa fa-info-circle'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'comment_awaiting_approval', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t{$comment->content()}\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->editLine() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t{$comment->editLine()}\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsItemControls'>\n\t\t\t\t\t\t\t<ul class='ipsComment_controls ipsClearfix ipsItemControls_left' data-role=\"commentControls\">\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->canReportOrRevoke() === TRUE ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<li><a href='\nCONTENT;\n$return .= htmlspecialchars( $comment->url('report'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' data-ipsDialog data-ipsDialog-remoteSubmit data-ipsDialog-size='medium' data-ipsDialog-flashMessage='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'report_submit_success', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n' data-ipsDialog-title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'report', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\" data-action='reportComment' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'report_content', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'report', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a><\/li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $comment->hidden() !== 1 && \\IPS\\IPS::classUsesTrait( $comment, 'IPS\\Content\\Reactable' ) and \\IPS\\Settings::i()->reputation_enabled ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->reputation( $comment );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t<\/ul>\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction blogStatistics( $stats, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'block_blogStatistics', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h3>\n<div class='ipsWidget_inner'>\n\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t<div class='ipsPad_half'>\n\t\t\t<ul class='ipsDataList' id='elBlogStats'>\n\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t<div class='ipsDataItem_main ipsPos_middle'>\n\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_blogs', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsDataItem_stats ipsDataItem_statsLarge'>\n\t\t\t\t\t\t<span class='ipsDataItem_stats_number'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['total_blogs'] );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t<div class='ipsDataItem_main ipsPos_middle'>\n\t\t\t\t\t\t<strong>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_entries', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsDataItem_stats ipsDataItem_statsLarge'>\n\t\t\t\t\t\t<span class='ipsDataItem_stats_number'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['total_entries'] );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t<\/ul>\n\t\t<\/div>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<div class='ipsGrid ipsGrid_collapsePhone ipsWidget_stats'>\n\t\t\t<div class='ipsGrid_span6 ipsType_center'>\n\t\t\t\t<span class='ipsType_large ipsWidget_statsCount'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['total_blogs'] );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\t<span class='ipsType_light ipsType_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_blogs', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<\/div>\n\t\t\t<div class='ipsGrid_span6 ipsType_center'>\n\t\t\t\t<span class='ipsType_large ipsWidget_statsCount'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['total_entries'] );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\t<span class='ipsType_light ipsType_medium'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_entries', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<\/div>\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction blogs( $blogs, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n<div class='ipsPad_half ipsWidget_inner'>\n\t<ul class='ipsDataList ipsDataList_reducedSpacing'>\n\t\t\nCONTENT;\n\nforeach ( $blogs as $blog ):\n$return .= <<<CONTENT\n\n\t\t\t<li class='ipsDataItem'>\n\t\t\t<div class='ipsColumns ipsColumns_collapsePhone'>\n\t\t\t\t<h4 class='ipsSpacer_top ipsSpacer_half ipsType_reset ipsTruncate ipsTruncate_line'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $blog->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($blog->_title); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_blog', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $blog->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/h4>\n\t\t\t\t<div>\n\t\t\t\t\t<ul class='ipsGrid'>\n\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->_items, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->_items ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_entries', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->_comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->_comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->num_views, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->num_views ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_views', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\t<\/div>\n\t\t\t<\/li>\n\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t<\/ul>\n<\/div>\n\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t<ol class=\"ipsDataList ipsClear cBlogList ipsAreaBackground ipsDataList_large\" data-role=\"tableRows\">\n\t\nCONTENT;\n\nforeach ( $blogs as $blog ):\n$return .= <<<CONTENT\n\n\t\t<li class='ipsDataItem ipsAreaBackground_reset'>\n\t\t\t<div class='ipsColumns ipsColumns_collapsePhone'>\n\t\t\t\t<div class='ipsColumn ipsColumn_veryWide cBlogInfo'>\n\t\t\t\t\t{$blog->coverPhoto()}\n\t\t\t\t\t<div class='ipsPad'>\n\t\t\t\t\t\t<ul class='ipsGrid'>\n\t\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->_items, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->_items ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_entries', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->_comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->_comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\t<li class='ipsGrid_span4'><strong class='ipsType_normal'>\nCONTENT;\n$return .= htmlspecialchars( $blog->num_views, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/strong><br>\nCONTENT;\n\n$pluralize = array( $blog->num_views ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'blog_views', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( \\count( $blog->_recentEntries ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<h4 class='ipsType_minorHeading'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'recent_entries', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h4>\n\t\t\t\t\t\t\t<ul class='ipsDataList ipsDataList_reducedSpacing ipsType_medium ipsList_reset ipsType_light'>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $blog->_recentEntries as $entry ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t\t\t\t\t<div class='ipsDataItem_main ipsType_break ipsContained'>\n\t\t\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $entry->url( \"getPrefComment\" ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($entry->name); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsType_break'>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $entry->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t\t<\/a>\n\t\t\t\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/div>\n\t\t\t\t<div class='ipsColumn ipsColumn_fluid ipsPad'>\n\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='ipsPhotoPanel ipsPhotoPanel_mini'>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->userPhoto( $blog->latestEntry()->author(), 'mini' );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t\t<strong class='ipsType_minorHeading'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'latest_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong><br>\n\t\t\t\t\t\t\t\t<h3 class='ipsType_reset ipsType_sectionHead ipsType_blendLinks ipsContained_container'>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->prefix() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span>\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->prefix( $blog->latestEntry()->prefix( TRUE ), $blog->latestEntry()->prefix() );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->isFutureDate() || $blog->latestEntry()->mapped('pinned') || $blog->latestEntry()->mapped('featured') || $blog->latestEntry()->hidden() === -1 || $blog->latestEntry()->hidden() === 1 || $blog->latestEntry()->status === 'draft' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->isFutureDate() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_warning\" data-ipsTooltip title='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->futureDateBlurb(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'><i class='fa fa-clock-o'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelseif ( $blog->latestEntry()->hidden() === -1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_warning\" data-ipsTooltip title='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->hiddenBlurb(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'><i class='fa fa-eye-slash'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nelseif ( $blog->latestEntry()->hidden() === 1 ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_warning\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'pending_approval', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='fa fa-warning'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->mapped('pinned') ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_positive\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'pinned', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='fa fa-thumb-tack'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->mapped('featured') ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_positive\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'featured', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='fa fa-star'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->status === 'draft' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<span><span class=\"ipsBadge ipsBadge_icon ipsBadge_small ipsBadge_warning\" data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'unpublished', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='fa fa-pencil-square-o'><\/i><\/span><\/span>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<span class='ipsType_break ipsContained'>\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->unread() ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->url('getNewComment'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n'><span class='ipsItemStatus' data-ipsTooltip title=\"\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'unread_blog', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n\"><i class=\"fa fa-circle\"><\/i><\/span><\/a>&nbsp;\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( $blog->latestEntry()->locked() ):\n$return .= <<<CONTENT\n<span data-ipsTooltip title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'locked', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'><i class='ipsType_medium fa fa-lock'><\/i><\/span> \nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->url( \"getPrefComment\" ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($blog->latestEntry()->name); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a>\n\t\t\t\t\t\t\t\t\t<\/span>\n\t\t\t\t\t\t\t\t<\/h3>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nif ( !( $blog->owner() instanceof \\IPS\\Member ) ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t\t<p class='ipsType_medium ipsType_reset ipsType_light'>\nCONTENT;\n\n$htmlsprintf = array(trim( $blog->latestEntry()->author()->link() )); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n \nCONTENT;\n\n$val = ( $blog->latestEntry()->date instanceof \\IPS\\DateTime ) ? $blog->latestEntry()->date : \\IPS\\DateTime::ts( $blog->latestEntry()->date );$return .= $val->html();\n$return .= <<<CONTENT\n<\/p>\n\t\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsType_medium ipsType_richText ipsSpacer_both cBlogInfo_content'>\n\t\t\t\t\t\t\t{$blog->latestEntry()->content()}\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<ul class='ipsList_inline'>\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<strong><a href='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->url( \"getPrefComment\" ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'read_more_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'read_more', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/a><\/strong>\n\t\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->blog_enable_rating ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<li>\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->rating( 'small', $blog->latestEntry()->averageRating(), 5, $blog->latestEntry()->memberRating() );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\nif ( !$blog->latestEntry()->num_comments ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<li class='ipsType_light'>\nCONTENT;\n\n$pluralize = array( $blog->latestEntry()->num_comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\t<li><a href='\nCONTENT;\n$return .= htmlspecialchars( $blog->latestEntry()->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n#comments' title='\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'see_comments_on_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n'>\nCONTENT;\n\n$pluralize = array( $blog->latestEntry()->num_comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/a><\/li>\n\t\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<p class='ipsEmpty ipsType_center'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'no_entries_yet', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/p>\n\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/div>\n\t\t\t\t\n\t\t\t<\/div>\n\t\t<\/li>\n\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t<\/ol>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction entryFeed( $entries, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $entries )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\t<div class='ipsPad_half ipsWidget_inner'>\n\t\t<ul class='ipsDataList ipsDataList_reducedSpacing'>\n\t\t\t\nCONTENT;\n\nforeach ( $entries as $entry ):\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"widgets\", \"blog\" )->entryRow( $entry, $orientation );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t<\/ul>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction entryRow( $entry, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<li class='ipsDataItem'>\n\t<div class='ipsDataItem_icon ipsPos_top'>\n\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->userPhoto( $entry->author(), 'tiny' );\n$return .= <<<CONTENT\n\n\t<\/div>\n\t<div class='ipsDataItem_main'>\n\t\t<div class='ipsContained ipsType_break'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $entry->url('getLastComment'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($entry->_title); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_entry', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsType_medium ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $entry->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/div>\n\t\t<span class='ipsType_blendLinks ipsType_light ipsType_medium ipsType_break ipsContained'>\nCONTENT;\n\n$htmlsprintf = array($entry->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline_nodate', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'in', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n <a href='\nCONTENT;\n$return .= htmlspecialchars( $entry->container()->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' class='ipsType_blendLinks ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $entry->container()->_title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/span>\n\t\t\nCONTENT;\n\nif ( \\IPS\\Settings::i()->blog_enable_rating ):\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\", 'front' )->rating( 'small', $entry->averageRating(), 5, $entry->memberRating() );\n$return .= <<<CONTENT\n &nbsp;&nbsp;\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<span class='ipsType_medium ipsType_reset'>\nCONTENT;\n\nif ( !$entry->num_comments ):\n$return .= <<<CONTENT\n<span class='ipsType_light'>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n<i class='fa fa-comment'><\/i> \nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $entry->num_comments );\n$return .= <<<CONTENT\n\nCONTENT;\n\nif ( !$entry->num_comments ):\n$return .= <<<CONTENT\n<\/span>\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n<\/span>\n\t\t\nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\n\n\t\t\t<div class='ipsType_medium ipsType_richText ipsType_break' data-ipsTruncate data-ipsTruncate-type='remove' data-ipsTruncate-size='2 lines'>\n\t\t\t\t{$entry->truncated()}\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/div>\n<\/li>\nCONTENT;\n\n\t\treturn $return;\n}}"
VALUE;
