<?php

return <<<'VALUE'
"namespace IPS\\Theme;\nclass class_gallery_front_widgets extends \\IPS\\Theme\\Template\n{\n\tpublic $cache_key = 'eb3f847938f9c2e3e1bf899066121da7';\n\tfunction albums( $albums, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $albums )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\t\t\nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\n\n\t\t\t<div class='ipsWidget_inner ipsPad'>\n\t\t\t\t<div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots>\n\t\t\t\t\t<div class='ipsCarousel_inner'>\n\t\t\t\t\t\t<ul class='cGalleryCarousel ipsGrid ipsGrid_collapsePhone' data-role=\"carouselItems\">\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t<div class='ipsWidget_inner'>\n\t\t\t\t<div class='ipsPad_half'>\n\t\t\t\t\t<ul class='ipsList_reset cGalleryWidgetList'>\n        \nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\n\t\t\nCONTENT;\n\nforeach ( $albums as $album ):\n$return .= <<<CONTENT\n\n\t\t\t<li class='cGalleryWidget cGalleryWidget_album \nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\nipsCarousel_item\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' data-ipsLazyLoad>\n\t\t\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $album->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' \nCONTENT;\n\nif ( $album->asNode()->coverPhoto('small') ):\n$return .= <<<CONTENT\n\nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\ndata-background-src=\"\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), $album->asNode()->coverPhoto('small') );;\n$return .= <<<CONTENT\n\"\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nstyle='background-image: url(\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), $album->asNode()->coverPhoto('small') );;\n$return .= <<<CONTENT\n)'\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n class='ipsThumb ipsThumb_bg\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n cGalleryWidget_verticalThumb\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n cGalleryAlbumThumb\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n cGalleryTrimmedImage\nCONTENT;\n\nif ( !$album->asNode()->coverPhoto('small') AND $album->asNode()->lastImage() AND $album->asNode()->lastImage()->media ):\n$return .= <<<CONTENT\n ipsNoThumb ipsNoThumb_video cGalleryNoThumb_full ipsType_left\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'>\n\t\t\t\t\t<h2 class='ipsType_sectionHead ipsTruncate ipsTruncate_line'>\n\t\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $album->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/h2>\n\t\t\t\t\t\nCONTENT;\n\nif ( $album->asNode()->coverPhoto('small') ):\n$return .= <<<CONTENT\n<img \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\nsrc=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Text\\Parser::blankImage(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\nsrc='\nCONTENT;\n$return .= htmlspecialchars( $album->asNode()->coverPhoto('small'), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' alt=\"\nCONTENT;\n$return .= htmlspecialchars( $album->name, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<ul class='ipsList_inline ipsType_left cGalleryWidget_albumInfo'>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<span>\nCONTENT;\n\n$sprintf = array($album->author()->name); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\t\t\nCONTENT;\n\n$val = ( $album->mapped('updated') instanceof \\IPS\\DateTime ) ? $album->mapped('updated') : \\IPS\\DateTime::ts( $album->mapped('updated') );$return .= $val->html();\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $album->use_comments ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li class='ipsPos_right' data-ipsTooltip title='\nCONTENT;\n\n$pluralize = array( $album->comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n'><i class='fa fa-comment'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $album->comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nif ( $album->allow_comments ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t<li class='ipsPos_right' data-ipsTooltip title='\nCONTENT;\n\n$pluralize = array( $album->count_comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'gallery_image_comments_s', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n'><i class='fa fa-comment'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $album->count_comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<li class='ipsPos_right' data-ipsTooltip title='\nCONTENT;\n\n$pluralize = array( $album->count_imgs ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'cat_img_count', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n'><i class='fa fa-camera'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $album->count_imgs, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/li>\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/a>\n\t\t\t<\/li>\n\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\n\t\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<\/ul>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t\t\t\t\t<span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t\t\t\t\t<a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t\t\t\t<\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction galleryStats( $stats, $latestImage, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'block_galleryStats', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/h3>\n<div class='ipsWidget_inner'>\n\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t<div class='ipsPad_half'>\t\t\n\t\t\t<ul class='ipsDataList' id='elGalleryStats'>\n\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t<div class='ipsDataItem_main ipsPos_middle'>\n\t\t\t\t\t\t<strong>\nCONTENT;\n\n$pluralize = array( $stats['totalImages'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_images_front_v', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsDataItem_stats ipsDataItem_statsLarge'>\n\t\t\t\t\t\t<span class='ipsDataItem_stats_number'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalImages'] );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nif ( $stats['totalComments'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t<div class='ipsDataItem_main ipsPos_middle'>\n\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$pluralize = array( $stats['totalComments'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'stats_total_comments_v', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsDataItem_stats ipsDataItem_statsLarge'>\n\t\t\t\t\t\t\t<span class='ipsDataItem_stats_number'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalComments'] );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\t\nCONTENT;\n\nif ( $stats['totalAlbums'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t\t<div class='ipsDataItem_main ipsPos_middle'>\n\t\t\t\t\t\t\t<strong>\nCONTENT;\n\n$pluralize = array( $stats['totalAlbums'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_albums_v', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/strong>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t\t<div class='ipsDataItem_stats ipsDataItem_statsLarge'>\n\t\t\t\t\t\t\t<span class='ipsDataItem_stats_number'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalAlbums'] );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/li>\n\t\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t<\/ul>\n\t\t\t\nCONTENT;\n\nif ( $latestImage ):\n$return .= <<<CONTENT\n\n\t\t\t\t<hr class='ipsHr'>\n\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"widgets\", \"gallery\" )->latestImage( $latestImage, $orientation );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$columns = 1;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$columns += ( $stats['totalComments'] ) ? 1 : 0;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$columns += ( $stats['totalAlbums'] ) ? 1 : 0;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\n$span = 12 \/ $columns;\n$return .= <<<CONTENT\n\n\t\t<div class='ipsGrid ipsGrid_collapsePhone ipsWidget_stats'>\n\t\t\t<div class='ipsGrid_span\nCONTENT;\n$return .= htmlspecialchars( $span, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n ipsType_center'>\n\t\t\t\t<span class='ipsType_large ipsWidget_statsCount'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalImages'] );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\t<span class='ipsType_light ipsType_medium'>\nCONTENT;\n\n$pluralize = array( $stats['totalImages'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_images_front_h', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nif ( $stats['totalComments'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsGrid_span\nCONTENT;\n$return .= htmlspecialchars( $span, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n ipsType_center'>\n\t\t\t\t\t<span class='ipsType_large ipsWidget_statsCount'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalComments'] );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\t\t<span class='ipsType_light ipsType_medium'>\nCONTENT;\n\n$pluralize = array( $stats['totalComments'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'stats_total_comments_h', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\nif ( $stats['totalAlbums'] ):\n$return .= <<<CONTENT\n\n\t\t\t\t<div class='ipsGrid_span\nCONTENT;\n$return .= htmlspecialchars( $span, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n ipsType_center'>\n\t\t\t\t\t<span class='ipsType_large ipsWidget_statsCount'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->formatNumber( $stats['totalAlbums'] );\n$return .= <<<CONTENT\n<\/span><br>\n\t\t\t\t\t<span class='ipsType_light ipsType_medium'>\nCONTENT;\n\n$pluralize = array( $stats['totalAlbums'] ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'total_albums_h', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n<\/span>\n\t\t\t\t<\/div>\n\t\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n<\/div>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction imageFeed( $images, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $images )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n        \nCONTENT;\n\nif ( $orientation == 'horizontal' ):\n$return .= <<<CONTENT\n\n            <div class='ipsWidget_inner ipsPad'>\n        \nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n            <div class='ipsWidget_inner'>\n        \nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\t\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n\n\t\t\t<div class='ipsPad_half'>\n\t\t\t\t<ul class='ipsList_reset cGalleryWidgetList' data-controller='gallery.front.browse.imageLightbox'>\n\t\t\t\t\t\nCONTENT;\n\nforeach ( $images as $image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"widgets\", \"gallery\" )->imageRow( $image, $orientation );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t<\/ul>\n\t\t\t<\/div>\n\t\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t        <div class='ipsCarousel ipsClearfix' data-ipsCarousel data-ipsCarousel-showDots>\n\t        \t<div class='ipsCarousel_inner'>\n\t\t\t\t\t<ul class='cGalleryCarousel ipsGrid ipsGrid_collapsePhone' data-role=\"carouselItems\" data-controller='gallery.front.browse.imageLightbox'>\n\t\t\t\t\t\t\nCONTENT;\n\nforeach ( $images as $idx => $image ):\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"widgets\", \"gallery\" )->imageRow( $image, $orientation );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/ul>\n\t\t\t\t<\/div>\n\t            <span class='ipsCarousel_shadow ipsCarousel_shadowLeft'><\/span>\n\t            <span class='ipsCarousel_shadow ipsCarousel_shadowRight'><\/span>\n\t            <a href='#' class='ipsCarousel_nav ipsHide' data-action='prev'><i class='fa fa-chevron-left'><\/i><\/a>\n\t            <a href='#' class='ipsCarousel_nav ipsHide' data-action='next'><i class='fa fa-chevron-right'><\/i><\/a>\n\t        <\/div>\n\t\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction imageRow( $image, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<li class='cGalleryWidget \nCONTENT;\n\nif ( $orientation != 'vertical' ):\n$return .= <<<CONTENT\nipsCarousel_item\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' data-ipsLazyLoad>\n\t\nCONTENT;\n\nif ( $image->small_file_name ):\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $image->url()->setQueryString( 'context', 'widget' ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($image->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsThumb ipsThumb_bg\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n cGalleryWidget_verticalThumb\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n ipsThumb_large\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\ndata-background-src=\"\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), \\IPS\\File::get( 'gallery_Images', $image->small_file_name )->url );;\n$return .= <<<CONTENT\n\"\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nstyle='background-image: url(\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), \\IPS\\File::get( 'gallery_Images', $image->small_file_name )->url );;\n$return .= <<<CONTENT\n)'\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n data-imageLightbox>\n\t\t\t<img \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\nsrc=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Text\\Parser::blankImage(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\nsrc='\nCONTENT;\n\n$return .= \\IPS\\File::get( \"gallery_Images\", $image->small_file_name )->url;\n$return .= <<<CONTENT\n' alt=\"\nCONTENT;\n$return .= htmlspecialchars( $image->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t<\/a>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $image->url()->setQueryString( 'context', 'widget' ), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($image->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_video', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsNoThumb ipsNoThumb_video ipsThumb_bg \nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n cGalleryWidget_verticalThumb\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n ipsThumb_large\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' data-imageLightbox><\/a>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $image->directContainer()->allow_comments ):\n$return .= <<<CONTENT\n\n\t\t<div class=\"cGalleryWidget_comments \nCONTENT;\n\nif ( $image->comments === 0 ):\n$return .= <<<CONTENT\nipsFaded\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" data-ipsTooltip title='\nCONTENT;\n\n$pluralize = array( $image->comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n'>\n\t\t\t<i class='fa fa-comment'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $image->comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<div class='ipsSpacer_top ipsSpacer_half cGalleryWidgetInfo'>\n\t\t\t<div class='ipsTruncate ipsTruncate_line'>\n\t\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $image->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($image->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='cGalleryWidget_title ipsType_medium'>\n\t\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $image->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t\t<\/a>\n\t\t\t<\/div>\n\t\t<span class='ipsType_medium ipsType_blendLinks ipsTruncate ipsTruncate_line'>\n\t\t\t\nCONTENT;\n\n$htmlsprintf = array($image->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$val = ( $image->mapped('date') instanceof \\IPS\\DateTime ) ? $image->mapped('date') : \\IPS\\DateTime::ts( $image->mapped('date') );$return .= $val->html();\n$return .= <<<CONTENT\n\n\t\t<\/span>\n\t<\/div>\n<\/li>\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction latestImage( $latestImage, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n<div id='elGalleryStatsLatest' class='ipsClearfix cGalleryWidget' data-ipsLazyLoad>\n\t<strong class='ipsType_minorHeading'>\nCONTENT;\n\n$return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'latest_image', ENT_DISALLOWED, 'UTF-8', FALSE ), TRUE, array(  ) );\n$return .= <<<CONTENT\n<\/strong><br>\n\t\nCONTENT;\n\nif ( $latestImage->small_file_name ):\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $latestImage->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($latestImage->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsThumb ipsThumb_bg\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n cGalleryWidget_verticalThumb\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n' \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\ndata-background-src=\"\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), \\IPS\\File::get( 'gallery_Images', $latestImage->small_file_name )->url );;\n$return .= <<<CONTENT\n\"\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\nstyle='background-image: url(\nCONTENT;\n\n$return .= str_replace( array( '(', ')' ), array( '\\(', '\\)' ), \\IPS\\File::get( 'gallery_Images', $latestImage->small_file_name )->url );;\n$return .= <<<CONTENT\n)'\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n>\n\t\t\t<img \nCONTENT;\n\nif ( \\IPS\\Settings::i()->lazy_load_enabled ):\n$return .= <<<CONTENT\nsrc=\"\nCONTENT;\n\n$return .= htmlspecialchars( \\IPS\\Text\\Parser::blankImage(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" data-\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\nsrc='\nCONTENT;\n\n$return .= \\IPS\\File::get( \"gallery_Images\", $latestImage->small_file_name )->url;\n$return .= <<<CONTENT\n' alt=\"\nCONTENT;\n$return .= htmlspecialchars( $latestImage->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\">\n\t\t<\/a>\n\t\nCONTENT;\n\nelse:\n$return .= <<<CONTENT\n\n\t\t<a href='\nCONTENT;\n$return .= htmlspecialchars( $latestImage->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n' title='\nCONTENT;\n\n$sprintf = array($latestImage->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_video', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsNoThumb ipsNoThumb_video ipsThumb_bg\nCONTENT;\n\nif ( $orientation == 'vertical' ):\n$return .= <<<CONTENT\n cGalleryWidget_verticalThumb\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n'><\/a>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t\nCONTENT;\n\nif ( $latestImage->directContainer()->allow_comments ):\n$return .= <<<CONTENT\n\n\t\t<div class=\"cGalleryWidget_comments \nCONTENT;\n\nif ( $latestImage->comments === 0 ):\n$return .= <<<CONTENT\nipsFaded\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\" data-ipsTooltip title='\nCONTENT;\n\n$pluralize = array( $latestImage->comments ); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'num_comments', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'pluralize' => $pluralize ) );\n$return .= <<<CONTENT\n'>\n\t\t\t<i class='fa fa-comment'><\/i> \nCONTENT;\n$return .= htmlspecialchars( $latestImage->comments, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t<\/div>\n\t\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\n\t<div class='ipsSpacer_top ipsSpacer_half cGalleryWidgetInfo'>\n\t\t<div class='ipsTruncate ipsTruncate_line'>\n\t\t\t<a href=\"\nCONTENT;\n$return .= htmlspecialchars( $latestImage->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($latestImage->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='cGalleryWidget_title ipsType_medium'>\n\t\t\t\t\nCONTENT;\n$return .= htmlspecialchars( $latestImage->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\n\t\t\t<\/a>\n\t\t<\/div>\n\t\t<span class='ipsType_medium ipsType_blendLinks'>\n\t\t\t\nCONTENT;\n\n$htmlsprintf = array($latestImage->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n\n\t\t\t\nCONTENT;\n\n$val = ( $latestImage->mapped('date') instanceof \\IPS\\DateTime ) ? $latestImage->mapped('date') : \\IPS\\DateTime::ts( $latestImage->mapped('date') );$return .= $val->html();\n$return .= <<<CONTENT\n\n\t\t<\/span>\n\t<\/div>\n<\/div>\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction recentComments( $comments, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $comments )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\t<div class='ipsPad_half ipsWidget_inner'>\n\t\t<ul class='ipsDataList ipsDataList_reducedSpacing'>\n\t\t\t\nCONTENT;\n\nforeach ( $comments as $comment ):\n$return .= <<<CONTENT\n\n\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t<div class='ipsDataItem_icon ipsPos_top'>\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->thumbImage( $comment->item()->small_file_name, $comment->item()->caption, 'tiny', '', 'view_this', '', 'gallery_Images' );\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t<div class='ipsContained ipsType_break'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($comment->item()->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsType_medium ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $comment->item()->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/div>\n\t\t\t\t\t\t<p class='ipsType_reset ipsType_light ipsType_medium ipsType_blendLinks'>\nCONTENT;\n\n$htmlsprintf = array($comment->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline_nodate', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n &middot; <a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" class='ipsDataItem_title ipsType_break ipsType_blendLinks'>{$comment->dateLine()}<\/a><\/p>\n\t\t\t\t\t\t<div class='ipsType_richText ipsType_medium ipsSpacer_top ipsSpacer_half ipsType_break' data-ipsTruncate data-ipsTruncate-type=\"remove\" data-ipsTruncate-size=\"2 lines\">\n\t\t\t\t\t\t\t{$comment->truncated()}\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t<\/ul>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}\n\n\tfunction recentImageReviews( $comments, $title, $orientation='vertical' ) {\n\t\t$return = '';\n\t\t$return .= <<<CONTENT\n\n\nCONTENT;\n\nif ( !empty( $comments )  ):\n$return .= <<<CONTENT\n\n\t<h3 class='ipsType_reset ipsWidget_title'>\nCONTENT;\n$return .= htmlspecialchars( $title, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/h3>\n\t<div class='ipsPad_half ipsWidget_inner'>\n\t\t<ul class='ipsDataList ipsDataList_reducedSpacing'>\n\t\t\t\nCONTENT;\n\nforeach ( $comments as $comment ):\n$return .= <<<CONTENT\n\n\t\t\t\t<li class='ipsDataItem'>\n\t\t\t\t\t<div class='ipsDataItem_generic ipsDataItem_size1'>\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\" )->thumbImage( $comment->item()->small_file_name, $comment->item()->caption, 'tiny', '', 'view_this', '', 'gallery_Images' );\n$return .= <<<CONTENT\n\n\t\t\t\t\t<\/div>\n\t\t\t\t\t<div class='ipsDataItem_main'>\n\t\t\t\t\t\t<div class='ipsContained ipsType_break'><a href=\"\nCONTENT;\n$return .= htmlspecialchars( $comment->url(), ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n\" title='\nCONTENT;\n\n$sprintf = array($comment->item()->caption); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'view_this_image', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'sprintf' => $sprintf ) );\n$return .= <<<CONTENT\n' class='ipsType_medium ipsTruncate ipsTruncate_line'>\nCONTENT;\n$return .= htmlspecialchars( $comment->item()->caption, ENT_QUOTES | ENT_DISALLOWED, 'UTF-8', FALSE );\n$return .= <<<CONTENT\n<\/a><\/div>\n\t\t\t\t\t\t<p class='ipsType_reset ipsType_light ipsType_medium ipsType_blendLinks'>\nCONTENT;\n\n$htmlsprintf = array($comment->author()->link()); $return .= \\IPS\\Member::loggedIn()->language()->addToStack( htmlspecialchars( 'byline_nodate', ENT_DISALLOWED, 'UTF-8', FALSE ), FALSE, array( 'htmlsprintf' => $htmlsprintf ) );\n$return .= <<<CONTENT\n<\/p>\n\t\t\t\t\t\t\nCONTENT;\n\n$return .= \\IPS\\Theme::i()->getTemplate( \"global\", \"core\", 'front' )->rating( 'small', $comment->rating, \\IPS\\Settings::i()->reviews_rating_out_of );\n$return .= <<<CONTENT\n\n\t\t\t\t\t\t<div class='ipsType_richText ipsType_medium ipsSpacer_top ipsSpacer_half' data-ipsTruncate data-ipsTruncate-type=\"remove\" data-ipsTruncate-size=\"2 lines\">\n\t\t\t\t\t\t\t{$comment->truncated()}\n\t\t\t\t\t\t<\/div>\n\t\t\t\t\t<\/div>\n\t\t\t\t<\/li>\n\t\t\t\nCONTENT;\n\nendforeach;\n$return .= <<<CONTENT\n\n\t\t<\/ul>\n\t<\/div>\n\nCONTENT;\n\nendif;\n$return .= <<<CONTENT\n\nCONTENT;\n\n\t\treturn $return;\n}}"
VALUE;
